/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.editor.AdaptedChild;
import net.officefloor.eclipse.editor.ChildrenGroup;
import net.officefloor.eclipse.editor.internal.parts.AdaptedChildPart;
import net.officefloor.model.Model;
import org.eclipse.gef.mvc.fx.parts.AbstractContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class ChildrenGroupPart<R extends Model, O>
extends AbstractContentPart<Pane> {
    private final ListChangeListener<AdaptedChild<?>> changeListener = change -> this.refreshContentChildren();

    public ChildrenGroup<?, ?> getContent() {
        return (ChildrenGroup)super.getContent();
    }

    public void setContent(Object content) {
        if (this.getContent() != null) {
            this.getContent().getChildren().removeListener(this.changeListener);
        }
        if (content != null && !(content instanceof ChildrenGroup)) {
            throw new IllegalArgumentException("Only " + ChildrenGroup.class.getSimpleName() + " supported.");
        }
        super.setContent(content);
        if (content != null) {
            this.getContent().getChildren().addListener(this.changeListener);
        }
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        return this.getContent().getChildren();
    }

    protected Pane doCreateVisual() {
        AdaptedChildPart parent = (AdaptedChildPart)this.getParent();
        Pane pane = parent.getChildrenGroupPane((ChildrenGroup<?, ?>)this.getContent());
        pane.getStyleClass().add((Object)"children");
        pane.getStyleClass().add((Object)this.getContent().getChildrenGroupName());
        return pane;
    }

    protected void doAddChildVisual(IVisualPart<? extends Node> child, int index) {
        ((Pane)this.getVisual()).getChildren().add(index, (Object)child.getVisual());
    }

    protected void doRemoveChildVisual(IVisualPart<? extends Node> child, int index) {
        ((Pane)this.getVisual()).getChildren().remove(index);
    }

    protected void doRefreshVisual(Pane visual) {
    }
}

