/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import java.util.Map;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.mvc.fx.handlers.HoverOnHoverHandler;
import org.eclipse.gef.mvc.fx.parts.AbstractHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class HoverHandleContainerPart
extends AbstractHandlePart<VBox> {
    public HoverHandleContainerPart() {
        this.setAdapter(new HoverOnHoverHandler(){

            public void hover(MouseEvent e) {
            }
        });
    }

    protected void doAddChildVisual(IVisualPart<? extends Node> child, int index) {
        ((VBox)this.getVisual()).getChildren().add(index, (Object)child.getVisual());
        for (Map.Entry anchorage : this.getAnchoragesUnmodifiable().entries()) {
            child.attachToAnchorage((IVisualPart)anchorage.getKey(), (String)anchorage.getValue());
        }
    }

    protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        super.doAttachToAnchorageVisual(anchorage, role);
        for (IVisualPart child : this.getChildrenUnmodifiable()) {
            child.attachToAnchorage(anchorage, role);
        }
    }

    protected VBox doCreateVisual() {
        VBox vBox = new VBox();
        vBox.setPickOnBounds(true);
        return vBox;
    }

    protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
        super.doDetachFromAnchorageVisual(anchorage, role);
        for (IVisualPart child : this.getChildrenUnmodifiable()) {
            child.detachFromAnchorage(anchorage, role);
        }
    }

    protected void doRefreshVisual(VBox visual) {
        ObservableSetMultimap anchorages = this.getAnchoragesUnmodifiable();
        if (anchorages.isEmpty()) {
            return;
        }
        IVisualPart anchorage = (IVisualPart)anchorages.keys().iterator().next();
        this.refreshHandleLocation(anchorage.getVisual());
    }

    protected void refreshHandleLocation(Node hostVisual) {
        Bounds hostBounds = hostVisual.getBoundsInParent();
        Parent parent = hostVisual.getParent();
        if (parent != null) {
            hostBounds = parent.localToScene(hostBounds);
        }
        Point2D location = ((VBox)this.getVisual()).getParent().sceneToLocal(hostBounds.getMaxX(), hostBounds.getMinY());
        ((VBox)this.getVisual()).setLayoutX(location.getX());
        ((VBox)this.getVisual()).setLayoutY(location.getY());
    }

    protected void registerAtVisualPartMap(IViewer viewer, VBox visual) {
    }

    protected void doRemoveChildVisual(IVisualPart<? extends Node> child, int index) {
        ((VBox)this.getVisual()).getChildren().remove(index);
    }

    protected void unregisterFromVisualPartMap(IViewer viewer, VBox visual) {
    }
}

