/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import com.google.inject.Injector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import javax.inject.Singleton;
import net.officefloor.eclipse.editor.AdaptedArea;
import net.officefloor.eclipse.editor.AdaptedBuilderContext;
import net.officefloor.eclipse.editor.AdaptedChild;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactory;
import net.officefloor.eclipse.editor.AdaptedConnection;
import net.officefloor.eclipse.editor.AdaptedConnectionManagementBuilder;
import net.officefloor.eclipse.editor.AdaptedConnector;
import net.officefloor.eclipse.editor.AdaptedEditorPlugin;
import net.officefloor.eclipse.editor.AdaptedErrorHandler;
import net.officefloor.eclipse.editor.AdaptedModel;
import net.officefloor.eclipse.editor.AdaptedParent;
import net.officefloor.eclipse.editor.AdaptedParentBuilder;
import net.officefloor.eclipse.editor.AdaptedRootBuilder;
import net.officefloor.eclipse.editor.ChangeExecutor;
import net.officefloor.eclipse.editor.ChildrenGroup;
import net.officefloor.eclipse.editor.ModelActionContext;
import net.officefloor.eclipse.editor.OverlayVisualFactory;
import net.officefloor.eclipse.editor.PaletteIndicatorStyler;
import net.officefloor.eclipse.editor.PaletteStyler;
import net.officefloor.eclipse.editor.SelectOnly;
import net.officefloor.eclipse.editor.internal.models.AbstractAdaptedFactory;
import net.officefloor.eclipse.editor.internal.models.AdaptedParentFactory;
import net.officefloor.eclipse.editor.internal.parts.AdaptedAreaPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedChildPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectionPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectorPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedOverlayHandlePart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedParentPart;
import net.officefloor.eclipse.editor.internal.parts.ChildrenGroupPart;
import net.officefloor.eclipse.editor.internal.style.StyleRegistry;
import net.officefloor.model.ConnectionModel;
import net.officefloor.model.Model;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.models.GridModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPartFactory;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

@Singleton
public class OfficeFloorContentPartFactory<R extends Model, O>
implements IContentPartFactory,
AdaptedRootBuilder<R, O>,
AdaptedBuilderContext,
PaletteIndicatorStyler,
PaletteStyler {
    private Injector injector;
    private Class<R> rootModelClass;
    private Function<R, O> createOperations;
    private final List<Function<R, List<? extends Model>>> getParentFunctions = new LinkedList<Function<R, List<? extends Model>>>();
    private final Map<Class<?>, AbstractAdaptedFactory<R, O, ?, ?, ?>> models = new HashMap();
    private final List<AbstractAdaptedFactory<R, O, ?, ?, ?>> orderedModels = new LinkedList();
    private final Map<Model, AdaptedModel<?>> modelToAdaption = new HashMap();
    private R rootModel;
    private O operations;
    private Pane editorPane;
    private IViewer contentViewer;
    private Property<String> editorStyle;
    private IViewer paletteViewer;
    private Property<String> paletteStyle;
    private Pane paletteIndicator;
    private Property<String> paletteIndicatorStyle;
    private ChangeExecutor changeExecutor;
    private AdaptedErrorHandler errorHandler;
    private StyleRegistry styleRegistry;
    private SelectOnly selectOnly = null;

    public static List<IFeedbackPart<? extends Node>> createFeedbackParts(List<? extends IVisualPart<? extends Node>> targets, Function<List<IVisualPart<? extends Node>>, List<IFeedbackPart<? extends Node>>> createFeedbackParts) {
        ArrayList<IVisualPart<? extends Node>> filteredTargets = new ArrayList<IVisualPart<? extends Node>>(targets.size());
        for (IVisualPart<? extends Node> iVisualPart : targets) {
            AdaptedConnectionPart connectionPart;
            if (!(iVisualPart instanceof AdaptedConnectionPart) || !((AdaptedConnection)(connectionPart = (AdaptedConnectionPart)iVisualPart).getContent()).canRemove()) continue;
            filteredTargets.add(iVisualPart);
        }
        return filteredTargets.size() == 0 ? Collections.emptyList() : createFeedbackParts.apply(filteredTargets);
    }

    public void init(Injector injector, Pane editorPane, IViewer content, Pane paletteIndicator, IViewer palette, AdaptedErrorHandler errorHandler, ChangeExecutor changeExecutor, StyleRegistry styleRegistry, SelectOnly selectOnly) {
        this.injector = injector;
        this.editorPane = editorPane;
        this.contentViewer = content;
        this.paletteViewer = palette;
        this.errorHandler = errorHandler;
        this.changeExecutor = changeExecutor;
        this.styleRegistry = styleRegistry;
        this.selectOnly = selectOnly;
        this.editorStyle = new SimpleStringProperty(null);
        ReadOnlyProperty<URL> editorUrl = this.styleRegistry.registerStyle("_editor_", (ReadOnlyProperty<String>)this.editorStyle);
        editorUrl.addListener((event, oldValue, newValue) -> {
            if (oldValue != null) {
                this.editorPane.getStylesheets().remove((Object)oldValue.toExternalForm());
            }
            if (newValue != null) {
                this.editorPane.getScene().getStylesheets().add((Object)newValue.toExternalForm());
            }
        });
        if (this.selectOnly != null) {
            this.contentViewer.getCanvas().setOnMouseClicked(event -> this.errorHandler.isError(() -> this.selectOnly.editor(this)));
        }
        this.paletteIndicator = paletteIndicator;
        this.paletteIndicatorStyle = new SimpleStringProperty(null);
        ReadOnlyProperty<URL> paletteIndicatorUrl = this.styleRegistry.registerStyle("_palette_indicator_", (ReadOnlyProperty<String>)this.paletteIndicatorStyle);
        paletteIndicatorUrl.addListener((event, oldValue, newValue) -> {
            if (oldValue != null) {
                this.paletteIndicator.getStylesheets().remove((Object)oldValue.toExternalForm());
            }
            if (newValue != null) {
                this.paletteIndicator.getStylesheets().add((Object)newValue.toExternalForm());
            }
        });
        if (this.selectOnly != null) {
            this.paletteIndicator.setOnMouseClicked(event -> this.errorHandler.isError(() -> this.selectOnly.paletteIndicator(this)));
        }
        this.paletteStyle = new SimpleStringProperty(null);
        ReadOnlyProperty<URL> paletteUrl = this.styleRegistry.registerStyle("_palette_", (ReadOnlyProperty<String>)this.paletteStyle);
        paletteUrl.addListener((event, oldValue, newValue) -> {
            if (oldValue != null) {
                this.paletteViewer.getCanvas().getStylesheets().remove((Object)oldValue.toExternalForm());
            }
            if (newValue != null) {
                this.paletteViewer.getCanvas().getStylesheets().add((Object)newValue.toExternalForm());
            }
        });
        if (this.selectOnly != null) {
            this.paletteViewer.getCanvas().setOnMouseClicked(event -> {
                if (event.getTarget() != this.paletteViewer.getCanvas()) {
                    this.errorHandler.isError(() -> this.selectOnly.palette(this));
                }
            });
        }
    }

    public <M extends Model, E extends Enum<E>> void registerModel(AbstractAdaptedFactory<R, O, M, E, ?> builder) {
        this.models.put(builder.getModelClass(), builder);
        this.orderedModels.add(builder);
    }

    public StyleRegistry getStyleRegistry() {
        return this.styleRegistry;
    }

    public boolean isCreateParent() {
        for (AbstractAdaptedFactory<R, O, ?, ?, ?> adaptedFactory : this.models.values()) {
            AdaptedParentFactory parentFactory;
            if (!(adaptedFactory instanceof AdaptedParentFactory) || !(parentFactory = (AdaptedParentFactory)adaptedFactory).isCreate()) continue;
            return true;
        }
        return false;
    }

    public void loadRootModel(Model rootModel) {
        if (rootModel == null) {
            throw new IllegalStateException("No root model provided");
        }
        if (!this.rootModelClass.equals(rootModel.getClass())) {
            throw new IllegalStateException("Incorrect root model type " + rootModel.getClass().getName() + " as configured with " + this.rootModelClass.getName());
        }
        this.rootModel = rootModel;
        this.operations = this.createOperations.apply(this.rootModel);
        AdaptedEditorPlugin.loadDefaulStylesheet(this.editorPane.getScene());
        Consumer<Property> reapplyStyle = style -> {
            String styleRules = (String)style.getValue();
            if (styleRules != null && styleRules.trim().length() > 0) {
                style.setValue((Object)"");
                style.setValue((Object)styleRules);
            }
        };
        reapplyStyle.accept(this.editorStyle);
        reapplyStyle.accept(this.paletteIndicatorStyle);
        reapplyStyle.accept(this.paletteStyle);
        this.models.values().forEach(model -> model.init(this.injector, this.models));
        this.models.values().forEach(model -> model.validate());
        OfficeFloorContentPartFactory factory = (OfficeFloorContentPartFactory)this.injector.getInstance(OfficeFloorContentPartFactory.class);
        LinkedList paletteModels = new LinkedList();
        for (AbstractAdaptedFactory<R, O, ?, ?, ?> adaptedFactory : this.orderedModels) {
            AdaptedParentFactory parentFactory;
            if (!(adaptedFactory instanceof AdaptedParentFactory) || !(parentFactory = (AdaptedParentFactory)adaptedFactory).isCreate()) continue;
            AdaptedModel adaptedPrototype = parentFactory.createPrototype(factory);
            paletteModels.add(adaptedPrototype);
        }
        this.paletteViewer.getContents().setAll(paletteModels);
        this.loadContentModels();
        this.rootModel.addPropertyChangeListener(event -> this.loadContentModels());
    }

    public void loadContentModels() {
        LinkedList<? extends Model> contentModels = new LinkedList<Model>();
        for (Function<R, List<Model>> getParents : this.getParentFunctions) {
            List<? extends Model> parents = getParents.apply(this.rootModel);
            if (parents == null) continue;
            contentModels.addAll(parents);
        }
        Iterator iterator = contentModels.iterator();
        while (iterator.hasNext()) {
            Object model = iterator.next();
            if (model != null) continue;
            iterator.remove();
        }
        ArrayList<AdaptedModel<Object>> adaptedContentModels = new ArrayList<AdaptedModel<Object>>();
        ArrayList<AdaptedParent> adaptedParents = new ArrayList<AdaptedParent>();
        for (Model model : contentModels) {
            AdaptedParent adaptedParent = (AdaptedParent)this.createAdaptedModel(model, null);
            if (adaptedContentModels.contains(adaptedParent)) continue;
            adaptedParents.add(adaptedParent);
            ((Model)adaptedParent.getModel()).addPropertyChangeListener(event -> {
                if (!adaptedParent.isAreaChangeEvent(event.getPropertyName())) {
                    return;
                }
                this.loadContentModels();
            });
        }
        for (AdaptedParent adaptedParent : adaptedParents) {
            for (AdaptedArea<?> adaptedArea : adaptedParent.getAdaptedAreas()) {
                if (adaptedContentModels.contains(adaptedArea)) continue;
                adaptedContentModels.add(adaptedArea);
            }
        }
        for (AdaptedParent adaptedParent : adaptedParents) {
            adaptedContentModels.add(adaptedParent);
        }
        for (AdaptedParent adaptedParent : adaptedParents) {
            List<AdaptedConnection<?>> connections = adaptedParent.getConnections();
            if (connections == null) continue;
            for (AdaptedConnection<?> connection : connections) {
                if (connection == null || adaptedContentModels.contains(connection)) continue;
                adaptedContentModels.add(connection);
            }
        }
        this.contentViewer.getContents().setAll(adaptedContentModels);
    }

    public <M extends Model> AdaptedModel<M> createAdaptedModel(M model, AdaptedModel<?> parentAdaptedModel) {
        if (model == null) {
            throw new IllegalArgumentException("Must provide model");
        }
        AdaptedModel<?> adapted = this.modelToAdaption.get(model);
        if (adapted != null) {
            return adapted;
        }
        AbstractAdaptedFactory<R, O, ?, ?, ?> builder = this.models.get(model.getClass());
        if (builder != null) {
            adapted = builder.newAdaptedModel(this.rootModel, this.operations, parentAdaptedModel, model);
            this.modelToAdaption.put(model, adapted);
            return adapted;
        }
        throw new IllegalStateException("Non-adapted model " + model.getClass().getName());
    }

    public <S extends Model, T extends Model, C extends ConnectionModel> void addConnection(S source, final T target, AdaptedConnectionManagementBuilder.ConnectionFactory<R, O, S, C, T> createConnection) {
        this.errorHandler.isError(() -> createConnection.addConnection(source, target, new ModelActionContext<R, O, C>(){

            @Override
            public R getRootModel() {
                return OfficeFloorContentPartFactory.this.rootModel;
            }

            @Override
            public O getOperations() {
                return OfficeFloorContentPartFactory.this.operations;
            }

            @Override
            public C getModel() {
                return null;
            }

            @Override
            public AdaptedModel<C> getAdaptedModel() {
                return null;
            }

            @Override
            public void overlay(OverlayVisualFactory overlayVisualFactory) {
                Point location = new Point((double)target.getX(), (double)target.getY());
                OfficeFloorContentPartFactory.this.overlay(location.x, location.y, overlayVisualFactory);
            }

            @Override
            public ChangeExecutor getChangeExecutor() {
                return OfficeFloorContentPartFactory.this.changeExecutor;
            }

            @Override
            public Injector getInjector() {
                return OfficeFloorContentPartFactory.this.injector;
            }

            @Override
            public C position(C model) {
                model.setX(target.getX());
                model.setY(target.getY());
                return model;
            }
        }));
    }

    public SelectOnly getSelectOnly() {
        return this.selectOnly;
    }

    public <r extends Model, o> AdaptedRootBuilder<r, o> root(Class<r> rootModelClass, Function<r, o> createOperations) {
        this.rootModelClass = rootModelClass;
        this.createOperations = createOperations;
        return this;
    }

    @Override
    public <M extends Model, E extends Enum<E>, RE extends Enum<RE>> AdaptedParentBuilder<R, O, M, E> parent(M modelPrototype, Function<R, List<M>> getParents, AdaptedChildVisualFactory<M> viewFactory, RE ... changeParentEvents) {
        this.getParentFunctions.add(getParents);
        return new AdaptedParentFactory(this.rootModelClass.getSimpleName(), modelPrototype, viewFactory, this);
    }

    @Override
    public void overlay(double x, double y, OverlayVisualFactory overlayVisualFactory) {
        this.contentViewer.getRootPart().addChild((IVisualPart)new AdaptedOverlayHandlePart(new Point(x, y), overlayVisualFactory));
    }

    @Override
    public AdaptedErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            throw new IllegalStateException(String.valueOf(AdaptedErrorHandler.class.getSimpleName()) + " not initialised for " + this.getClass().getName());
        }
        return this.errorHandler;
    }

    @Override
    public ChangeExecutor getChangeExecutor() {
        if (this.changeExecutor == null) {
            throw new IllegalStateException(String.valueOf(ChangeExecutor.class.getSimpleName()) + " not initialised for " + this.getClass().getName());
        }
        return this.changeExecutor;
    }

    @Override
    public Parent getEditor() {
        return this.editorPane;
    }

    @Override
    public GridModel getGridModel() {
        return (GridModel)this.contentViewer.getAdapter(GridModel.class);
    }

    @Override
    public Property<String> editorStyle() {
        return this.editorStyle;
    }

    @Override
    public Node getPaletteIndicator() {
        return this.paletteIndicator;
    }

    @Override
    public Property<String> paletteIndicatorStyle() {
        return this.paletteIndicatorStyle;
    }

    @Override
    public Node getPalette() {
        return this.paletteViewer.getCanvas();
    }

    @Override
    public Property<String> paletteStyle() {
        return this.paletteStyle;
    }

    public IContentPart<? extends Node> createContentPart(Object content, Map<Object, Object> contextMap) {
        if (content instanceof AdaptedParent) {
            return (IContentPart)this.injector.getInstance(AdaptedParentPart.class);
        }
        if (content instanceof AdaptedArea) {
            return (IContentPart)this.injector.getInstance(AdaptedAreaPart.class);
        }
        if (content instanceof ChildrenGroup) {
            return (IContentPart)this.injector.getInstance(ChildrenGroupPart.class);
        }
        if (content instanceof AdaptedChild) {
            return (IContentPart)this.injector.getInstance(AdaptedChildPart.class);
        }
        if (content instanceof AdaptedConnection) {
            return (IContentPart)this.injector.getInstance(AdaptedConnectionPart.class);
        }
        if (content instanceof AdaptedConnector) {
            return (IContentPart)this.injector.getInstance(AdaptedConnectorPart.class);
        }
        throw new IllegalArgumentException("Unhandled model " + content.getClass().getName());
    }
}

