/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import net.officefloor.eclipse.editor.internal.models.AdaptedAction;
import net.officefloor.eclipse.editor.internal.models.AdaptedActions;
import net.officefloor.eclipse.editor.internal.parts.AdaptedActionHandlePart;
import net.officefloor.eclipse.editor.internal.parts.HoverHandleContainerPart;
import org.eclipse.gef.geometry.planar.BezierCurve;
import org.eclipse.gef.mvc.fx.parts.DefaultHoverIntentHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class OfficeFloorHoverIntentHandlePartFactory
extends DefaultHoverIntentHandlePartFactory {
    @Inject
    private Injector injector;

    protected List<IHandlePart<? extends Node>> createHoverHandlePartsForPolygonalOutline(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        AdaptedActions actions = (AdaptedActions)target.getAdapter(AdaptedActions.class);
        if (actions == null || actions.getAdaptedActions().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IHandlePart<? extends Node>> handles = new ArrayList<IHandlePart<? extends Node>>();
        HoverHandleContainerPart rootHandler = new HoverHandleContainerPart();
        this.injector.injectMembers((Object)rootHandler);
        handles.add((IHandlePart<? extends Node>)rootHandler);
        for (AdaptedAction action : actions.getAdaptedActions()) {
            AdaptedActionHandlePart handlePart = (AdaptedActionHandlePart)this.injector.getInstance(AdaptedActionHandlePart.class);
            handlePart.setAdaptedAction(action);
            rootHandler.addChild((IVisualPart)handlePart);
        }
        return handles;
    }

    protected List<IHandlePart<? extends Node>> createHoverHandlePartsForRectangularOutline(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        return this.createHoverHandlePartsForPolygonalOutline(target, contextMap, segmentsProvider);
    }
}

