/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.editor.AdaptedConnection;
import net.officefloor.eclipse.editor.internal.parts.AdaptedConnectionPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedParentPart;
import org.eclipse.gef.geometry.planar.BezierCurve;
import org.eclipse.gef.mvc.fx.parts.AbstractHandlePart;
import org.eclipse.gef.mvc.fx.parts.CircleSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.DefaultSelectionHandlePartFactory;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class OfficeFloorSelectionHandlePartFactory
extends DefaultSelectionHandlePartFactory {
    protected List<IHandlePart<? extends Node>> createSingleSelectionHandlePartsForRectangularOutline(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        if (target instanceof AdaptedParentPart) {
            return Arrays.asList(new IHandlePart[]{new StyleClassHandlePart(target)});
        }
        return super.createSingleSelectionHandlePartsForRectangularOutline(target, contextMap, segmentsProvider);
    }

    protected List<IHandlePart<? extends Node>> createSingleSelectionHandlePartsForCurve(IVisualPart<? extends Node> target, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        AdaptedConnectionPart connectionPart;
        if (target instanceof AdaptedConnectionPart && !((AdaptedConnection)(connectionPart = (AdaptedConnectionPart)target).getContent()).canRemove()) {
            return Collections.emptyList();
        }
        List allHandleParts = super.createSingleSelectionHandlePartsForCurve(target, contextMap, segmentsProvider);
        ArrayList<IHandlePart<? extends Node>> circleHandleParts = new ArrayList<IHandlePart<? extends Node>>(2);
        for (IHandlePart handlePart : allHandleParts) {
            if (!(handlePart instanceof CircleSegmentHandlePart)) continue;
            circleHandleParts.add((IHandlePart<? extends Node>)handlePart);
        }
        return circleHandleParts;
    }

    private class StyleClassHandlePart
    extends AbstractHandlePart<Node> {
        private final IVisualPart<? extends Node> visualPart;

        public StyleClassHandlePart(IVisualPart<? extends Node> visualPart) {
            this.visualPart = visualPart;
        }

        protected void doAttachToAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
            super.doAttachToAnchorageVisual(anchorage, role);
            this.visualPart.getVisual().getStyleClass().add((Object)"selected");
        }

        protected void doDetachFromAnchorageVisual(IVisualPart<? extends Node> anchorage, String role) {
            this.visualPart.getVisual().getStyleClass().remove((Object)"selected");
            super.doDetachFromAnchorageVisual(anchorage, role);
        }

        protected Node doCreateVisual() {
            Pane pane = new Pane();
            pane.visibleProperty().set(false);
            return pane;
        }

        protected void doRefreshVisual(Node visual) {
        }

        protected void unregisterFromVisualPartMap(IViewer viewer, Node visual) {
            Map registry = viewer.getVisualPartMap();
            if (registry.get(visual) == this) {
                registry.remove(visual);
            }
        }
    }
}

