/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.parts;

import javafx.geometry.Bounds;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import net.officefloor.eclipse.editor.AdaptedModel;
import net.officefloor.eclipse.editor.internal.parts.AbstractAdaptedPart;
import net.officefloor.model.Model;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class TransformContent<M extends Model, A extends AdaptedModel<M>> {
    private final AbstractAdaptedPart<M, A, ?> part;
    private AffineTransform contentTransform = null;

    public TransformContent(AbstractAdaptedPart<M, A, ?> part) {
        this.part = part;
        Object model = this.part.getContent().getModel();
        this.contentTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)model.getX(), (double)model.getY());
    }

    public Affine getContentTransform() {
        return Geometry2FX.toFXAffine((AffineTransform)this.contentTransform);
    }

    public void setContentTransform(Affine totalTransform) {
        this.contentTransform = FX2Geometry.toAffineTransform((Transform)totalTransform);
        Bounds boundsInScene = this.part.getVisual().localToScene(this.part.getVisual().getLayoutBounds());
        Bounds boundsInParent = ((InfiniteCanvasViewer)this.part.getRoot().getViewer()).getCanvas().getScrolledOverlayGroup().sceneToLocal(boundsInScene);
        int x = (int)boundsInParent.getMinX();
        int y = (int)boundsInParent.getMinY();
        this.part.getContent().getModel().setX(x);
        this.part.getContent().getModel().setY(y);
    }
}

