/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.style;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import net.officefloor.eclipse.editor.internal.style.StyleRegistry;

public class AbstractStyleRegistry
implements StyleRegistry {
    public static final String PROTOCOL = "officefloorstyle";
    private static Map<String, ReadOnlyProperty<String>> urlPathToStyleContent = new HashMap<String, ReadOnlyProperty<String>>();
    private static AtomicInteger nextInstanceIndex = new AtomicInteger(1);
    private final int instanceIndex = nextInstanceIndex.getAndIncrement();

    public static URLConnection openConnection(URL url) throws IOException {
        OfficeFloorUrlConnection connection = new OfficeFloorUrlConnection(url);
        connection.connect();
        return connection;
    }

    public ReadOnlyProperty<String> getStylesheetContent(String url) {
        return null;
    }

    protected URL getUrl(String configurationPath, int version) {
        String url = "officefloorstyle://in.memory.host/" + String.valueOf(this.instanceIndex) + "/" + configurationPath + "?version=" + version;
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Failed to create URL for " + url, ex);
        }
    }

    @Override
    public ReadOnlyProperty<URL> registerStyle(String configurationPath, ReadOnlyProperty<String> stylesheetContent) {
        int[] version = new int[1];
        int n = version[0];
        version[0] = n + 1;
        URL url = this.getUrl(configurationPath, n);
        String urlPath = url.getPath();
        ReadOnlyProperty<String> stylesheetContentProperty = urlPathToStyleContent.get(urlPath);
        if (stylesheetContentProperty != null) {
            throw new IllegalStateException("Stylesheet already registered for URL " + url);
        }
        urlPathToStyleContent.put(urlPath, stylesheetContent);
        SimpleObjectProperty urlProperty = new SimpleObjectProperty((Object)url);
        stylesheetContent.addListener(arg_0 -> this.lambda$0((Property)urlProperty, configurationPath, version, arg_0));
        return urlProperty;
    }

    private /* synthetic */ void lambda$0(Property property, String string, int[] nArray, Observable change) {
        int n = nArray[0];
        nArray[0] = n + 1;
        property.setValue((Object)this.getUrl(string, n));
    }

    private static class OfficeFloorUrlConnection
    extends URLConnection {
        private ReadOnlyProperty<String> stylesheetContent;

        protected OfficeFloorUrlConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            String urlPath = this.getURL().getPath();
            this.stylesheetContent = (ReadOnlyProperty)urlPathToStyleContent.get(urlPath);
            if (this.stylesheetContent == null) {
                throw new IOException("URL " + this.getURL() + " has no style sheet registered");
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            byte[] data = new byte[]{};
            String content = (String)this.stylesheetContent.getValue();
            if (content != null) {
                data = content.getBytes();
            }
            return new ByteArrayInputStream(data);
        }
    }
}

