/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.internal.views;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.officefloor.eclipse.editor.AdaptedEditorModule;
import net.officefloor.eclipse.editor.AdaptedErrorHandler;
import net.officefloor.eclipse.editor.SelectOnly;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.mvc.fx.viewer.InfiniteCanvasViewer;

public class ViewersComposite
implements AdaptedErrorHandler {
    private static final double PALETTE_INDICATOR_WIDTH = 10.0;
    private final IViewer contentViewer;
    private final Pane paletteIndicator = new Pane();
    private final IViewer paletteViewer;
    private final SelectOnly selectOnly;
    private final VBox composite = new VBox();
    private final GridPane errorHeader = new GridPane();
    private final Label errorLabel = new Label();
    private final Hyperlink dismissError = new Hyperlink("dismiss");
    private final SplitPane editorWithStackTrace = new SplitPane();
    private final Hyperlink stackTraceToggle = new Hyperlink();
    private boolean isShowingStackTrace = false;
    private final TextArea stackTrace = new TextArea();
    private boolean isLoading = true;

    public ViewersComposite(IViewer contentViewer, IViewer paletteViewer, SelectOnly selectOnly) {
        this.contentViewer = contentViewer;
        this.paletteViewer = paletteViewer;
        this.selectOnly = selectOnly;
    }

    public void init(boolean isCreateParents) {
        InfiniteCanvas contentRootNode = ((InfiniteCanvasViewer)this.contentViewer).getCanvas();
        Pane contentPane = null;
        for (Node child : contentRootNode.getChildrenUnmodifiable()) {
            if (!(child instanceof Pane)) continue;
            contentPane = (Pane)child;
        }
        contentPane.getStyleClass().add((Object)"content");
        InfiniteCanvas paletteRootNode = ((InfiniteCanvasViewer)this.paletteViewer).getCanvas();
        Pane palettePane = null;
        for (Node child : paletteRootNode.getChildrenUnmodifiable()) {
            if (!(child instanceof Pane)) continue;
            palettePane = (Pane)child;
        }
        palettePane.getStyleClass().add((Object)"palette");
        palettePane.prefHeightProperty().bind((ObservableValue)paletteRootNode.heightProperty());
        AnchorPane viewersPane = new AnchorPane();
        viewersPane.getChildren().addAll((Object[])new Node[]{contentRootNode, paletteRootNode});
        HBox.setHgrow((Node)viewersPane, (Priority)Priority.ALWAYS);
        viewersPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        AnchorPane.setBottomAnchor((Node)contentRootNode, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)contentRootNode, (Double)0.0);
        AnchorPane.setRightAnchor((Node)contentRootNode, (Double)0.0);
        AnchorPane.setTopAnchor((Node)contentRootNode, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)paletteRootNode, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)paletteRootNode, (Double)0.0);
        AnchorPane.setTopAnchor((Node)paletteRootNode, (Double)0.0);
        paletteRootNode.setZoomGrid(false);
        paletteRootNode.setShowGrid(false);
        paletteRootNode.setHorizontalScrollBarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        paletteRootNode.setStyle("-fx-background-insets: 0; -fx-padding: 0; -fx-border-width: 0;");
        if (!isCreateParents) {
            paletteRootNode.setVisible(false);
        }
        ArrayList<Object> panes = new ArrayList<Object>(2);
        if (isCreateParents) {
            this.paletteIndicator.getStyleClass().add((Object)"palette-indicator");
            this.paletteIndicator.setMaxSize(10.0, Double.MAX_VALUE);
            this.paletteIndicator.setMinSize(10.0, 0.0);
            panes.add(this.paletteIndicator);
            this.paletteIndicator.setOnMouseEntered(event -> paletteRootNode.setVisible(true));
            paletteRootNode.setOnMouseExited(event -> paletteRootNode.setVisible(false));
            paletteRootNode.getContentGroup().layoutBoundsProperty().addListener((observable, oldValue, newValue) -> {
                double scrollBarWidth = paletteRootNode.getVerticalScrollBar().isVisible() ? paletteRootNode.getVerticalScrollBar().getLayoutBounds().getWidth() : 0.0;
                paletteRootNode.setPrefWidth(newValue.getWidth() + scrollBarWidth);
            });
            paletteRootNode.getVerticalScrollBar().visibleProperty().addListener((observable, oldValue, newValue) -> {
                double contentWidth = paletteRootNode.getContentGroup().getLayoutBounds().getWidth();
                double scrollBarWidth = newValue != false ? paletteRootNode.getVerticalScrollBar().getLayoutBounds().getWidth() : 0.0;
                paletteRootNode.setPrefWidth(contentWidth + scrollBarWidth);
            });
            if (this.selectOnly == null) {
                paletteRootNode.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
                    if (event.getTarget() != paletteRootNode) {
                        paletteRootNode.setVisible(false);
                    }
                });
            }
        }
        panes.add(viewersPane);
        HBox editor = new HBox();
        editor.getStyleClass().add((Object)"editor");
        editor.getChildren().addAll(panes);
        editor.setMinSize(0.0, 0.0);
        editor.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        editor.setFillHeight(true);
        editor.setSpacing(0.0);
        this.editorWithStackTrace.setOrientation(Orientation.HORIZONTAL);
        this.editorWithStackTrace.getItems().add((Object)editor);
        HBox errorDetails = new HBox(10.0);
        errorDetails.getStyleClass().setAll((Object[])new String[]{"header-panel"});
        String errorImagePath = String.valueOf(AdaptedEditorModule.class.getPackage().getName().replace('.', '/')) + "/error.png";
        ImageView errorImage = new ImageView(new Image(errorImagePath, 15.0, 15.0, true, true));
        this.errorLabel.alignmentProperty().setValue((Object)Pos.CENTER_LEFT);
        this.dismissError.getStyleClass().add((Object)"dismiss-error");
        this.dismissError.setOnAction(event -> this.showError((String)null));
        errorDetails.getChildren().setAll((Object[])new Node[]{errorImage, this.errorLabel, this.dismissError});
        this.stackTraceToggle.setText("Show Stack Trace");
        this.stackTraceToggle.getStyleClass().setAll((Object[])new String[]{"details-button", "more"});
        this.stackTraceToggle.setVisible(this.isShowingStackTrace);
        this.stackTraceToggle.setOnAction(event -> {
            if (this.isShowingStackTrace) {
                this.editorWithStackTrace.getItems().remove((Object)this.stackTrace);
                this.stackTraceToggle.setText("Show Stack Trace");
                this.stackTraceToggle.getStyleClass().setAll((Object[])new String[]{"details-button", "more"});
                this.isShowingStackTrace = false;
            } else {
                if (!this.editorWithStackTrace.getItems().contains((Object)this.stackTrace)) {
                    this.editorWithStackTrace.getItems().add((Object)this.stackTrace);
                }
                this.stackTraceToggle.setText("Hide Stack Trace");
                this.stackTraceToggle.getStyleClass().setAll((Object[])new String[]{"details-button", "less"});
                this.isShowingStackTrace = true;
            }
        });
        HBox stackTraceToggleContainer = new HBox();
        stackTraceToggleContainer.getChildren().add((Object)this.stackTraceToggle);
        stackTraceToggleContainer.getStyleClass().setAll((Object[])new String[]{"container"});
        stackTraceToggleContainer.alignmentProperty().setValue((Object)Pos.CENTER_RIGHT);
        HBox stackTraceToggleButtonBar = new HBox();
        stackTraceToggleButtonBar.getStyleClass().setAll((Object[])new String[]{"header-panel", "button-bar"});
        stackTraceToggleButtonBar.getChildren().setAll((Object[])new Node[]{stackTraceToggleContainer});
        this.errorHeader.getStyleClass().setAll((Object[])new String[]{"dialog-pane", "error-header"});
        this.errorHeader.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"header"), true);
        this.errorHeader.add((Node)errorDetails, 0, 0);
        this.errorHeader.add((Node)stackTraceToggleButtonBar, 1, 0);
        GridPane.setHgrow((Node)errorDetails, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)stackTraceToggleButtonBar, (Priority)Priority.SOMETIMES);
        this.stackTrace.setEditable(false);
        this.stackTrace.prefHeightProperty().bind((ObservableValue)this.editorWithStackTrace.heightProperty());
        this.stackTrace.prefWidthProperty().bind((ObservableValue)Bindings.divide((ObservableNumberValue)this.composite.widthProperty(), (int)2));
        this.composite.getChildren().add((Object)this.editorWithStackTrace);
        VBox.setVgrow((Node)this.editorWithStackTrace, (Priority)Priority.ALWAYS);
    }

    public Pane getPaletteIndicator() {
        return this.paletteIndicator;
    }

    public Pane getComposite() {
        return this.composite;
    }

    public void loadComplete() {
        this.isLoading = false;
    }

    @Override
    public void showError(String message) {
        this.showError(message == null || message.trim().length() == 0 ? null : new AdaptedErrorHandler.MessageOnlyException(message));
    }

    @Override
    public void showError(Throwable error) {
        String errorText = null;
        String stackTraceText = null;
        if (error != null) {
            errorText = error.getMessage();
            if (errorText == null || errorText.trim().length() == 0) {
                errorText = String.valueOf(error.getClass().getSimpleName()) + " thrown";
            }
            if (!(error instanceof AdaptedErrorHandler.MessageOnlyException)) {
                StringWriter buffer = new StringWriter();
                error.printStackTrace(new PrintWriter(buffer));
                stackTraceText = buffer.toString();
            }
        }
        if (errorText == null) {
            this.composite.getChildren().remove((Object)this.errorHeader);
        } else {
            this.errorLabel.setText(errorText);
            this.dismissError.setVisited(false);
            if (!this.composite.getChildren().contains((Object)this.errorHeader)) {
                this.composite.getChildren().add(0, (Object)this.errorHeader);
            }
        }
        if (stackTraceText == null) {
            this.stackTraceToggle.setVisible(false);
            this.editorWithStackTrace.getItems().remove((Object)this.stackTrace);
        } else {
            this.stackTrace.setText(stackTraceText);
            this.stackTraceToggle.setVisible(true);
        }
    }

    @Override
    public boolean isError(AdaptedErrorHandler.UncertainOperation operation) {
        try {
            operation.run();
            return false;
        }
        catch (Throwable ex) {
            if (this.isLoading) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
            this.showError(ex);
            return true;
        }
    }
}

