/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.editor.preview;

import java.net.URL;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import net.officefloor.eclipse.editor.AdaptedChildVisualFactory;
import net.officefloor.eclipse.editor.AdaptedEditorPlugin;
import net.officefloor.eclipse.editor.internal.parts.AdaptedChildPart;
import net.officefloor.eclipse.editor.internal.parts.AdaptedChildVisualFactoryContextImpl;
import net.officefloor.eclipse.editor.internal.parts.AdaptedParentPart;
import net.officefloor.eclipse.editor.internal.style.StyleRegistry;
import net.officefloor.model.Model;

public class AdaptedEditorPreview<M extends Model> {
    private final Scene previewScene;
    private final Node previewVisual;
    private final Property<String> styling = new SimpleStringProperty();

    public AdaptedEditorPreview(M model, String label, boolean isParent, AdaptedChildVisualFactory<M> visualFactory) {
        this.previewVisual = visualFactory.createVisual(model, new AdaptedChildVisualFactoryContextImpl(model.getClass(), false, () -> new SimpleStringProperty(label), (childGroupName, node) -> true, (connectionClasses, role, assocations, node) -> {}, action -> {}));
        Pane visualContainer = new Pane(new Node[]{this.previewVisual});
        visualContainer.setPadding(new Insets(10.0));
        visualContainer.setBackground(null);
        this.previewScene = new Scene((Parent)visualContainer);
        AdaptedChildPart.loadStyling(this.previewVisual, model.getClass(), null);
        if (isParent) {
            AdaptedParentPart.loadStyling(this.previewVisual);
        }
        AdaptedEditorPlugin.loadDefaulStylesheet(this.previewScene);
        if (this.previewVisual instanceof Parent) {
            Parent previewParent = (Parent)this.previewVisual;
            StyleRegistry styleRegistry = AdaptedEditorPlugin.createStyleRegistry();
            ReadOnlyProperty<URL> styleUrl = styleRegistry.registerStyle("_preview_", (ReadOnlyProperty<String>)this.styling);
            styleUrl.addListener((event, oldUrl, newUrl) -> {
                if (oldUrl != null) {
                    previewParent.getStylesheets().remove((Object)oldUrl.toExternalForm());
                }
                if (newUrl != null) {
                    previewParent.getStylesheets().add((Object)newUrl.toExternalForm());
                }
            });
        }
    }

    public Scene getPreviewScene() {
        return this.previewScene;
    }

    public Node getPreviewVisual() {
        return this.previewVisual;
    }

    public Property<String> style() {
        return this.styling;
    }
}

