/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.bridge;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import net.officefloor.compile.OfficeFloorCompiler;
import net.officefloor.eclipse.bridge.AdaptedIdePlugin;
import net.officefloor.gef.bridge.EnvironmentBridge;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class EclipseEnvironmentBridge
implements EnvironmentBridge {
    private final IJavaProject javaProject;
    private final List<Closeable> disposeItems = new LinkedList<Closeable>();
    private Shell parentShell;
    private ClassLoader classLoader = null;
    private OfficeFloorCompiler compiler = null;

    public EclipseEnvironmentBridge(IJavaProject javaProject) {
        this.javaProject = javaProject;
        IElementChangedListener listener = event -> {
            this.classLoader = null;
            this.compiler = null;
        };
        JavaCore.addElementChangedListener((IElementChangedListener)listener);
        this.disposeItems.add(() -> JavaCore.removeElementChangedListener((IElementChangedListener)listener));
    }

    public EclipseEnvironmentBridge() {
        this.javaProject = null;
    }

    public void init(Shell parentShell) {
        this.parentShell = parentShell;
    }

    public void dispose() throws IOException {
        for (Closeable item : this.disposeItems) {
            item.close();
        }
    }

    private IJavaProject getJavaProject() {
        if (this.javaProject == null) {
            throw new IllegalStateException("Attempting " + IJavaProject.class.getSimpleName() + " specific bridging outside " + IJavaProject.class.getSimpleName() + " context");
        }
        return this.javaProject;
    }

    public boolean isClassOnClassPath(String className) throws Exception {
        IType type = this.getJavaProject().findType(className, null);
        return type != null;
    }

    public boolean isSuperType(String className, String superTypeName) throws Exception {
        IType type = this.getJavaProject().findType(className);
        if (type == null) {
            throw new ClassNotFoundException("Class " + className + " not on class path");
        }
        IType superType = this.getJavaProject().findType(superTypeName);
        if (superType == null) {
            throw new ClassNotFoundException("Please add " + superTypeName + " to the class path");
        }
        ITypeHierarchy typeHierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        List<IType> superTypes = Arrays.asList(typeHierarchy.getAllSupertypes(type));
        return superTypes.stream().anyMatch(supertype -> supertype.getFullyQualifiedName().equals(superTypeName));
    }

    public void selectClass(String searchText, String superTypeName, EnvironmentBridge.SelectionHandler handler) {
        try {
            IType superType;
            IJavaSearchScope scope = null;
            if (superTypeName != null && (superType = this.getJavaProject().findType(superTypeName)) != null) {
                scope = SearchEngine.createStrictHierarchyScope((IJavaProject)this.getJavaProject(), (IType)superType, (boolean)true, (boolean)true, null);
            }
            if (scope == null) {
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{this.getJavaProject()}, (boolean)true);
            }
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.parentShell, (IRunnableContext)new ProgressMonitorDialog(this.parentShell), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(searchText == null ? "" : searchText));
            dialog.setBlockOnOpen(true);
            dialog.open();
            Object[] results = dialog.getResult();
            if (results == null || results.length != 1) {
                handler.cancelled();
                return;
            }
            Object selectedItem = results[0];
            if (!(selectedItem instanceof IType)) {
                handler.error((Exception)new IllegalStateException("Plugin Error: selected item is not of " + IType.class.getName() + " [" + (selectedItem == null ? null : selectedItem.getClass().getName()) + "]"));
                return;
            }
            handler.selected(((IType)selectedItem).getFullyQualifiedName());
        }
        catch (JavaModelException ex) {
            handler.error((Exception)((Object)ex));
        }
    }

    public <T> Class<? extends T> loadClass(String className, Class<T> superType) throws Exception {
        return this.getClassLoader().loadClass(className);
    }

    public ClassLoader getClassLoader() throws Exception {
        if (this.classLoader == null) {
            String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)this.getJavaProject());
            URL[] urls = new URL[classPathEntries.length];
            int i = 0;
            while (i < classPathEntries.length) {
                String path = classPathEntries[i];
                File file = new File(path);
                if (file.exists()) {
                    urls[i] = file.isDirectory() ? new URL("file", null, String.valueOf(path) + "/") : new URL("file", null, path);
                }
                ++i;
            }
            this.classLoader = new URLClassLoader(urls);
        }
        return this.classLoader;
    }

    public OfficeFloorCompiler getOfficeFloorCompiler() throws Exception {
        if (this.compiler == null) {
            ClassLoader classLoader = this.getClassLoader();
            this.compiler = OfficeFloorCompiler.newOfficeFloorCompiler((ClassLoader)classLoader);
        }
        return this.compiler;
    }

    public boolean isResourceOnClassPath(String resourcePath) throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        Enumeration<URL> resources = classLoader.getResources(resourcePath);
        return resources.hasMoreElements();
    }

    public void selectClassPathResource(String searchText, EnvironmentBridge.SelectionHandler handler) {
        String filter = searchText == null ? "" : searchText;
        int index = filter.lastIndexOf(47);
        if (index >= 0) {
            filter = filter.substring(index + "/".length());
        }
        if ((index = filter.indexOf(46)) >= 0) {
            filter = filter.substring(0, index);
        }
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.parentShell, false, (IContainer)this.getJavaProject().getProject(), 1);
        dialog.setInitialPattern(filter);
        dialog.setBlockOnOpen(true);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length != 1) {
            handler.cancelled();
            return;
        }
        Object selectedItem = results[0];
        if (selectedItem instanceof IFile) {
            IFile file = (IFile)selectedItem;
            handler.selected(this.getClassPathLocation(file));
        } else {
            handler.error((Exception)new IllegalStateException("Plugin Error: selected item is not of " + IFile.class.getName() + " [" + (selectedItem == null ? null : selectedItem.getClass().getName()) + "]"));
        }
    }

    private String getClassPathLocation(IFile file) {
        IResource pathResource;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = pathResource = workspaceRoot.findMember(file.getFullPath());
        IJavaElement javaElement = null;
        do {
            if (resource == null) {
                return null;
            }
            javaElement = JavaCore.create((IResource)resource);
            resource = resource.getParent();
        } while (javaElement == null);
        IPackageFragmentRoot fragmentRoot = null;
        do {
            if (javaElement instanceof IPackageFragmentRoot) {
                fragmentRoot = (IPackageFragmentRoot)javaElement;
            }
            javaElement = javaElement.getParent();
        } while (fragmentRoot == null && javaElement != null);
        if (fragmentRoot == null) {
            return file.getFullPath().toString();
        }
        String fragmentPath = String.valueOf(fragmentRoot.getResource().getFullPath().toString()) + "/";
        String fullPath = file.getFullPath().toString();
        String location = fullPath.substring(fragmentPath.length());
        return location;
    }

    public String getPreference(String preferenceId) {
        return AdaptedIdePlugin.getDefault().getPreferenceStore().getString(preferenceId);
    }

    public void setPreference(String preferenceId, String value) {
        AdaptedIdePlugin.getDefault().getPreferenceStore().setValue(preferenceId, value);
    }

    public void resetPreference(String preferenceId) {
        AdaptedIdePlugin.getDefault().getPreferenceStore().setToDefault(preferenceId);
    }

    public void addPreferenceListener(EnvironmentBridge.PreferenceListener listener) {
        Closeable cleanup = AdaptedIdePlugin.getDefault().addPreferenceListener(listener);
        this.disposeItems.add(cleanup);
    }
}

