/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.bridge;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.officefloor.configuration.ConfigurationError;
import net.officefloor.configuration.WritableConfigurationContext;
import net.officefloor.configuration.WritableConfigurationItem;
import net.officefloor.configuration.impl.AbstractWritableConfigurationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ProjectConfigurationContext
extends AbstractWritableConfigurationContext {
    private final IProject project;
    private final IProgressMonitor monitor;

    public static WritableConfigurationItem getWritableConfigurationItem(IFile file, IProgressMonitor monitor) {
        IProject project = file.getProject();
        ProjectConfigurationContext context = new ProjectConfigurationContext(project, monitor);
        return new IFileWritableConfigurationItem(file, context);
    }

    private static void ensureFolderExists(IContainer folder, IProgressMonitor monitor) throws CoreException {
        if (folder instanceof IProject) {
            return;
        }
        if (folder.exists()) {
            return;
        }
        ProjectConfigurationContext.ensureFolderExists(folder.getParent(), monitor);
        ((IFolder)folder).create(true, true, monitor);
    }

    public ProjectConfigurationContext(IProject project) {
        this(project, null);
    }

    public ProjectConfigurationContext(IProject project, IProgressMonitor monitor) {
        super(location -> {
            IFile file;
            block3: {
                try {
                    file = project.getFile(Path.fromPortableString((String)location));
                    if (file.exists()) break block3;
                    return null;
                }
                catch (CoreException ex) {
                    throw new IOException(ex);
                }
            }
            return file.getContents();
        }, (location, isCreate, content) -> {
            try {
                IFile file = project.getFile(Path.fromPortableString((String)location));
                ProjectConfigurationContext.ensureFolderExists(file.getParent(), monitor);
                if (isCreate) {
                    if (file.exists()) {
                        throw new IOException("File '" + location + "' can not be created as already exists");
                    }
                    file.create(content, false, monitor);
                } else {
                    if (!file.exists()) {
                        throw new IOException("File '" + location + "' can not be updated as not exist");
                    }
                    file.setContents(content, false, true, monitor);
                }
            }
            catch (CoreException ex) {
                throw new IOException(ex);
            }
        }, location -> {
            try {
                IFile file = project.getFile(Path.fromPortableString((String)location));
                if (!file.exists()) {
                    return;
                }
                file.delete(true, monitor);
            }
            catch (CoreException ex) {
                throw new IOException(ex);
            }
        }, null);
        this.project = project;
        this.monitor = monitor;
    }

    public IProject getProject() {
        return this.project;
    }

    private static class IFileWritableConfigurationItem
    implements WritableConfigurationItem {
        private final IFile file;
        private final ProjectConfigurationContext context;

        public IFileWritableConfigurationItem(IFile file, ProjectConfigurationContext context) {
            this.file = file;
            this.context = context;
        }

        public InputStream getInputStream() throws ConfigurationError {
            try {
                return this.file.getContents();
            }
            catch (CoreException coreException) {
                throw new ConfigurationError(this.file.getFullPath().toOSString());
            }
        }

        public Reader getReader() throws ConfigurationError {
            return new InputStreamReader(this.getInputStream());
        }

        public WritableConfigurationContext getContext() {
            return this.context;
        }

        public InputStream getRawConfiguration() throws IOException {
            try {
                return this.file.getContents();
            }
            catch (CoreException ex) {
                throw new IOException(ex);
            }
        }

        public void setConfiguration(InputStream contents) throws IOException {
            try {
                this.file.setContents(contents, false, true, this.context.monitor);
            }
            catch (CoreException ex) {
                throw new IOException(ex);
            }
        }
    }
}

