/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.ide;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import javafx.scene.Parent;
import javafx.scene.Scene;
import net.officefloor.configuration.WritableConfigurationItem;
import net.officefloor.eclipse.bridge.EclipseEnvironmentBridge;
import net.officefloor.eclipse.bridge.ProjectConfigurationContext;
import net.officefloor.gef.bridge.EnvironmentBridge;
import net.officefloor.gef.ide.editor.AbstractAdaptedIdeEditor;
import net.officefloor.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.ui.MvcFxUiModule;
import org.eclipse.gef.mvc.fx.ui.parts.AbstractFXEditor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAdaptedEditorPart<R extends Model, RE extends Enum<RE>, O>
extends AbstractFXEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAdaptedEditorPart.class);
    private static final Injector doNothingInjector;
    private EclipseEnvironmentBridge envBridge;
    private AbstractAdaptedIdeEditor<R, RE, O> editor;
    private AbstractAdaptedIdeEditor.ViewManager<R> viewManager;

    static {
        try {
            doNothingInjector = (Injector)Proxy.newProxyInstance(AbstractAdaptedEditorPart.class.getClassLoader(), new Class[]{Injector.class}, (proxy, method, args) -> null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create Injector mock for loading class", ex);
        }
    }

    public static void initEditor(AbstractAdaptedIdeEditor<?, ?, ?> editor, Function<Injector, IDomain> initialiser) {
        editor.init((Module)new MvcFxUiModule(), initialiser);
    }

    public abstract AbstractAdaptedIdeEditor<R, RE, O> createEditor(EnvironmentBridge var1);

    public AbstractAdaptedEditorPart() {
        super(doNothingInjector);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new IllegalStateException("Unable to edit input " + input.getClass().getName());
        }
        IFileEditorInput fileInput = (IFileEditorInput)input;
        IFile configurationFile = fileInput.getFile();
        WritableConfigurationItem configurationItem = ProjectConfigurationContext.getWritableConfigurationItem(configurationFile, null);
        IFile file = fileInput.getFile();
        IProject project = file.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.envBridge = new EclipseEnvironmentBridge(javaProject);
        this.editor = this.createEditor(this.envBridge);
        AbstractAdaptedEditorPart.initEditor(this.editor, injector -> {
            injector.injectMembers((Object)this);
            return this.getDomain();
        });
        this.editor.setConfigurationItem(configurationItem);
        super.init(site, input);
    }

    public void createPartControl(Composite parent) {
        Shell parentShell = parent.getShell();
        this.envBridge.init(parentShell);
        super.createPartControl(parent);
    }

    protected void hookViewers() {
        this.viewManager = this.editor.loadView(view -> this.getCanvas().setScene(new Scene((Parent)view)));
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        this.viewManager.save();
        this.markNonDirty();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("TODO implement EditorPart.doSaveAs");
    }

    public void dispose() {
        try {
            this.envBridge.dispose();
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to dispose of " + EclipseEnvironmentBridge.class.getSimpleName(), (Throwable)ex);
        }
        super.dispose();
    }
}

