/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.ide.newwizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import net.officefloor.eclipse.bridge.EclipseEnvironmentBridge;
import net.officefloor.eclipse.ide.newwizard.NewWizardPage;
import net.officefloor.gef.bridge.EnvironmentBridge;
import net.officefloor.gef.ide.editor.AbstractAdaptedIdeEditor;
import net.officefloor.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractNewWizard<R extends Model>
extends Wizard
implements INewWizard {
    private final String title;
    private final String description;
    private final String initialFileName;
    private final String extension;
    private final String itemFileContents;
    private NewWizardPage page = null;

    public AbstractNewWizard() {
        AbstractAdaptedIdeEditor<R, ?, ?> editor = this.createEditor(new EclipseEnvironmentBridge());
        this.title = editor.getClass().getSimpleName();
        this.description = "Create the " + this.title;
        this.initialFileName = editor.fileName();
        if (this.initialFileName == null || this.initialFileName.trim().length() == 0) {
            throw new IllegalStateException(String.valueOf(editor.getClass().getName()) + " not providing file name");
        }
        int extensionIndex = this.initialFileName.lastIndexOf(46);
        if (extensionIndex < 0) {
            throw new IllegalStateException(String.valueOf(editor.getClass().getName()) + " provided file does not have an extension");
        }
        this.extension = this.initialFileName.substring(extensionIndex + ".".length());
        try {
            this.itemFileContents = editor.newFileContent();
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    protected abstract AbstractAdaptedIdeEditor<R, ?, ?> createEditor(EnvironmentBridge var1);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page = new NewWizardPage(selection, this.title, this.title, this.description, this.initialFileName, this.extension);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IResource container = this.page.getItemContainer();
        String itemName = this.page.getItemFullName();
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.doFinish(container, itemName, monitor);
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IResource resource, String itemName, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Creating " + itemName, 2);
        if (!resource.exists() || !(resource instanceof IContainer)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Container \"" + resource + "\" does not exist."));
            return;
        }
        IContainer container = (IContainer)resource;
        monitor.setTaskName("Creating item file ...");
        final IFile file = container.getFile((IPath)new Path(itemName));
        ByteArrayInputStream stream = new ByteArrayInputStream(this.itemFileContents.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)stream, true, true, monitor);
        } else {
            file.create((InputStream)stream, true, monitor);
        }
        ((InputStream)stream).close();
        monitor.setTaskName("Opening file for editing ...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }
}

