/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.ide.newwizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

class NewWizardPage
extends WizardPage {
    private final IStructuredSelection selection;
    private final String initialFileName;
    private final String extension;
    private Text containerText;
    private Text itemText;

    NewWizardPage(IStructuredSelection selection, String pageName, String title, String description, String initialFileName, String extension) {
        super(pageName);
        this.selection = selection;
        this.initialFileName = initialFileName;
        this.extension = extension;
        this.setTitle(title);
        this.setDescription(description);
    }

    public IResource getItemContainer() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getItemContainerName()));
    }

    public String getItemContainerName() {
        return this.containerText.getText();
    }

    public String getItemFullName() {
        String itemName = this.getItemName();
        if (!itemName.trim().endsWith("." + this.extension)) {
            itemName = String.valueOf(itemName) + "." + this.extension;
        }
        return itemName;
    }

    public String getItemName() {
        return this.itemText.getText();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        new Label(container, 0).setText("Container:");
        this.containerText = new Text(container, 2052);
        this.containerText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.containerText.addListener(24, event -> this.handleDialogChanged());
        this.containerText.addListener(25, event -> this.handleDialogChanged());
        Button containerBrowse = new Button(container, 8);
        containerBrowse.setText("Browse...");
        containerBrowse.addListener(13, event -> this.handleContainerBrowse());
        new Label(container, 0).setText("Name:");
        this.itemText = new Text(container, 2052);
        this.itemText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.itemText.addListener(24, event -> this.handleDialogChanged());
        this.itemText.addListener(25, event -> this.handleDialogChanged());
        this.itemText.addListener(13, event -> this.itemText.selectAll());
        this.itemText.addListener(3, event -> this.itemText.selectAll());
        this.initialise();
        this.handleDialogChanged();
        this.setControl((Control)container);
    }

    private void initialise() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection.size() == 1) {
            Object object = this.selection.getFirstElement();
            Object resource = object instanceof IResource ? (IResource)object : (object instanceof IJavaElement ? ((IJavaElement)object).getResource() : null);
            IContainer container = resource == null ? null : (resource instanceof IContainer ? (IContainer)resource : resource.getParent());
            String containerPath = container == null ? "" : container.getFullPath().toString();
            this.containerText.setText(containerPath);
        }
        this.itemText.setText(this.initialFileName);
    }

    protected void handleContainerBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select new container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(result[0].toString());
        }
    }

    private void handleDialogChanged() {
        if (this.getItemContainerName().trim().length() == 0) {
            this.updateStatus("Container must be specified");
            return;
        }
        IResource container = this.getItemContainer();
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("Container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        String itemName = this.getItemName().trim();
        if (itemName.length() == 0) {
            this.updateStatus("Name must be specified");
            return;
        }
        if (itemName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("Name must be valid");
            return;
        }
        if (itemName.contains(".") && !itemName.endsWith("." + this.extension)) {
            this.updateStatus("Extension must be '" + this.extension + "'");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

