/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.ide.preferences;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.LinkedList;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import net.officefloor.eclipse.bridge.AdaptedIdePlugin;
import net.officefloor.eclipse.bridge.EclipseEnvironmentBridge;
import net.officefloor.eclipse.ide.AbstractAdaptedEditorPart;
import net.officefloor.gef.bridge.EnvironmentBridge;
import net.officefloor.gef.ide.editor.AbstractAdaptedIdeEditor;
import net.officefloor.gef.ide.preferences.PreferencesEditor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.fx.swt.canvas.IFXCanvasFactory;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficeFloorIdePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeFloorIdePreferencePage.class);
    private EditorInstance[] editors;
    private TabFolder editorTabs;
    @Inject
    private IDomain domain;
    @Inject
    private IFXCanvasFactory canvasFactory;

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AdaptedIdePlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        EditorInstance active = this.getActiveEditor();
        active.preferences.resetToDefaults();
        super.performDefaults();
    }

    protected void performApply() {
        EditorInstance active = this.getActiveEditor();
        active.preferences.apply();
        super.performApply();
    }

    public boolean performOk() {
        EditorInstance[] editorInstanceArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            EditorInstance instance = editorInstanceArray[n2];
            instance.preferences.apply();
            ++n2;
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite progressContainer = new Composite(container, 0);
        GridDataFactory.defaultsFor((Control)progressContainer).align(4, 128).grab(true, false).applyTo((Control)progressContainer);
        progressContainer.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(progressContainer, 0);
        label.setText("Loading editors  ");
        ProgressBar progress = new ProgressBar(progressContainer, 0);
        GridDataFactory.defaultsFor((Control)progress).align(4, 128).grab(true, false).applyTo((Control)progress);
        this.loadEditors(progress, progressContainer, container, parent.getDisplay());
        return container;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getApplyButton().setVisible(false);
        this.getDefaultsButton().setVisible(false);
    }

    private EditorInstance getActiveEditor() {
        TabItem editorTab = this.editorTabs.getSelection()[0];
        return (EditorInstance)editorTab.getData();
    }

    private void loadEditors(ProgressBar progress, Composite progressContainer, Composite container, Display display) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.editors");
        progress.setMaximum(elements.length);
        new Thread(() -> {
            EditorInstance[] finalEditors;
            LinkedList<EditorInstance> editorInstances = new LinkedList<EditorInstance>();
            int i = 0;
            while (i < elements.length) {
                block10: {
                    Object extension;
                    IConfigurationElement element = elements[i];
                    try {
                        extension = element.createExecutableExtension("class");
                    }
                    catch (Exception ex) {
                        String editorName = element.getAttribute("class");
                        if (editorName == null) {
                            editorName = element.getNamespaceIdentifier();
                        }
                        LOGGER.info("Failed to load " + editorName + " : " + ex.getMessage(), (Throwable)ex);
                        break block10;
                    }
                    if (extension instanceof AbstractAdaptedEditorPart) {
                        AbstractAdaptedEditorPart editPart = (AbstractAdaptedEditorPart)((Object)((Object)extension));
                        try {
                            EclipseEnvironmentBridge envBridge = new EclipseEnvironmentBridge();
                            AbstractAdaptedIdeEditor editor = editPart.createEditor(envBridge);
                            PreferencesEditor preferences = new PreferencesEditor(editor, (EnvironmentBridge)envBridge);
                            editorInstances.add(new EditorInstance(editor, preferences, envBridge));
                        }
                        catch (Exception ex) {
                            LOGGER.info("Failed to load preferences editor from " + ((Object)((Object)editPart)).getClass().getName() + " : " + ex.getMessage(), (Throwable)ex);
                            break block10;
                        }
                        int progressSelection = i;
                        display.asyncExec(() -> {
                            if (progress.isDisposed()) {
                                return;
                            }
                            progress.setSelection(progressSelection);
                        });
                    }
                }
                ++i;
            }
            OfficeFloorIdePreferencePage officeFloorIdePreferencePage = this;
            synchronized (officeFloorIdePreferencePage) {
                finalEditors = editorInstances.toArray(new EditorInstance[editorInstances.size()]);
            }
            display.asyncExec(() -> {
                if (!progressContainer.isDisposed()) {
                    progressContainer.dispose();
                }
                if (container.isDisposed()) {
                    return;
                }
                OfficeFloorIdePreferencePage officeFloorIdePreferencePage = this;
                synchronized (officeFloorIdePreferencePage) {
                    this.editors = finalEditors;
                }
                this.loadPreferencePage(container);
                container.layout();
            });
        }).start();
    }

    protected void loadPreferencePage(Composite parent) {
        Arrays.sort(this.editors, (a, b) -> ((EditorInstance)a).editor.getClass().getSimpleName().compareTo(((EditorInstance)b).editor.getClass().getSimpleName()));
        this.editorTabs = new TabFolder(parent, 2050);
        this.editorTabs.setLayoutData((Object)new GridData(4, 4, true, true));
        Shell parentShell = parent.getShell();
        EditorInstance[] editorInstanceArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            EditorInstance instance = editorInstanceArray[n2];
            instance.envBridge.init(parentShell);
            TabItem editorTab = new TabItem(this.editorTabs, 2);
            editorTab.setText(instance.editor.getClass().getSimpleName());
            editorTab.setData((Object)instance);
            if (this.canvasFactory == null) {
                AbstractAdaptedEditorPart.initEditor(instance.editor, injector -> {
                    injector.injectMembers((Object)this);
                    return this.domain;
                });
            }
            FXCanvas canvas = this.canvasFactory.createCanvas((Composite)this.editorTabs, 0);
            editorTab.setControl((Control)canvas);
            instance.preferences.loadView(view -> canvas.setScene(new Scene((Parent)view)));
            ++n2;
        }
        this.getDefaultsButton().setVisible(true);
        this.getApplyButton().setVisible(true);
    }

    private class EditorInstance {
        private final AbstractAdaptedIdeEditor<?, ?, ?> editor;
        private final PreferencesEditor<?> preferences;
        private final EclipseEnvironmentBridge envBridge;

        private EditorInstance(AbstractAdaptedIdeEditor<?, ?, ?> editor, PreferencesEditor<?> preferences, EclipseEnvironmentBridge envBridge) {
            this.editor = editor;
            this.preferences = preferences;
            this.envBridge = envBridge;
        }
    }
}

