/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.ide.swt;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.paint.Color;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class SwtUtil {
    public static final String BACKGROUND_COLOR = "background-color";

    public static void autoHideScrollbars(Text text) {
        Listener scrollBarListener = event -> {
            Rectangle r1 = text.getClientArea();
            Rectangle r2 = text.computeTrim(r1.x, r1.y, r1.width, r1.height);
            Point p = text.computeSize(-1, -1, true);
            text.getHorizontalBar().setVisible(r2.width <= p.x);
            text.getVerticalBar().setVisible(r2.height <= p.y);
            if (event.type == 24) {
                text.getParent().layout(true);
                text.showSelection();
            }
        };
        text.addListener(11, scrollBarListener);
        text.addListener(24, scrollBarListener);
    }

    public static void autoHideScrollbars(StyledText text) {
        Listener scrollBarListener = event -> {
            Rectangle r1 = text.getClientArea();
            Rectangle r2 = text.computeTrim(r1.x, r1.y, r1.width, r1.height);
            Point p = text.computeSize(-1, -1, true);
            text.getHorizontalBar().setVisible(r2.width <= p.x);
            text.getVerticalBar().setVisible(r2.height <= p.y);
            if (event.type == 24) {
                text.getParent().layout(true);
                text.showSelection();
            }
        };
        text.addListener(11, scrollBarListener);
        text.addListener(24, scrollBarListener);
    }

    public static ControlDecoration errorDecoration(Control control, int style) {
        ControlDecoration decorator = new ControlDecoration(control, style);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image img = fieldDecoration.getImage();
        decorator.setImage(img);
        decorator.hide();
        return decorator;
    }

    public static Map<String, Color> loadThemeColours(Object uiObject, boolean isDispose) {
        Color backgroundColour;
        Widget widget;
        if (uiObject instanceof Widget) {
            widget = (Widget)uiObject;
        } else if (uiObject instanceof Viewer) {
            widget = ((Viewer)uiObject).getControl();
        } else {
            throw new IllegalStateException("Unknown UI object type " + uiObject.getClass().getName());
        }
        Bundle bundle = FrameworkUtil.getBundle(SwtUtil.class);
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference themeManagerReference = bundleContext.getServiceReference(IThemeManager.class);
        IThemeManager themeManager = (IThemeManager)bundle.getBundleContext().getService(themeManagerReference);
        IThemeEngine themeEngine = themeManager.getEngineForDisplay(widget.getDisplay());
        themeEngine.applyStyles((Object)widget, true);
        HashMap<String, Color> colours = new HashMap<String, Color>();
        SwtUtil.extractColours(widget, "", colours, themeEngine);
        if (isDispose) {
            widget.dispose();
        }
        if ((backgroundColour = (Color)colours.get(BACKGROUND_COLOR)) == null) {
            org.eclipse.swt.graphics.Color swtBackgroundColor = widget.getDisplay().getSystemColor(22);
            backgroundColour = Color.color((double)(swtBackgroundColor.getRed() / 255), (double)(swtBackgroundColor.getGreen() / 255), (double)(swtBackgroundColor.getBlue() / 255), (double)(swtBackgroundColor.getAlpha() / 255));
        }
        return colours;
    }

    private static void extractColours(Widget widget, String prefix, Map<String, Color> colours, IThemeEngine themeEngine) {
        CSSStyleDeclaration style = themeEngine.getStyle((Object)widget);
        if (style != null) {
            int i = 0;
            while (i < style.getLength()) {
                String name = style.item(i);
                CSSValue value = style.getPropertyCSSValue(name);
                if (value instanceof RGBColor) {
                    RGBColor valueColour = (RGBColor)((Object)value);
                    double red = Double.parseDouble(valueColour.getRed().getCssText()) / 255.0;
                    double green = Double.parseDouble(valueColour.getGreen().getCssText()) / 255.0;
                    double blue = Double.parseDouble(valueColour.getBlue().getCssText()) / 255.0;
                    Color colour = Color.color((double)red, (double)green, (double)blue);
                    colours.put(String.valueOf(prefix) + name, colour);
                }
                ++i;
            }
        }
        if (widget instanceof Composite) {
            Composite composite = (Composite)widget;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SwtUtil.extractColours((Widget)child, String.valueOf(prefix) + widget.getClass().getSimpleName() + ".", colours, themeEngine);
                ++n2;
            }
        }
    }

    private SwtUtil() {
    }
}

