/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.launch;

import net.officefloor.OfficeFloorMain;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class OfficeFloorLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        try {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object item = structuredSelection.getFirstElement();
            if (item == null) {
                return;
            }
            if (!(item instanceof IAdaptable)) {
                return;
            }
            IAdaptable adaptable = (IAdaptable)item;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource == null) {
                return;
            }
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigType = launchManager.getLaunchConfigurationType("net.officefloor.eclipse.launch.configurationtype.officeFloor");
            String resourceName = resource.getName();
            String extension = resource.getFileExtension();
            if (extension != null) {
                resourceName = resourceName.replace("." + extension, "");
            }
            ILaunchConfiguration launchConfig = null;
            ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations(launchConfigType);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration existingConfig = iLaunchConfigurationArray[n2];
                if (resourceName.equalsIgnoreCase(existingConfig.getName())) {
                    launchConfig = existingConfig;
                }
                ++n2;
            }
            if (launchConfig == null) {
                String uniqueConfigName = launchManager.generateLaunchConfigurationName(resourceName);
                ILaunchConfigurationWorkingCopy launchConfigWorkingCopy = launchConfigType.newInstance(null, uniqueConfigName);
                launchConfigWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, resource.getProject().getName());
                launchConfigWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, OfficeFloorMain.class.getName());
                launchConfig = launchConfigWorkingCopy.doSave();
            }
            DebugUITools.launch(launchConfig, (String)mode);
        }
        catch (CoreException ex) {
            ErrorDialog.openError(null, (String)"Error launching", (String)"Failed to launch", (IStatus)ex.getStatus());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        MessageDialog.openError((Shell)editor.getEditorSite().getShell(), (String)"Error", (String)"Should not run from editor");
    }
}

