/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.eclipse.osgi;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import net.officefloor.compile.OfficeFloorCompiler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class OfficeFloorOsgiBridge {
    private final IJavaProject javaProject;
    private ClassLoader classLoader = null;
    private OfficeFloorCompiler compiler = null;

    public static OfficeFloorOsgiBridge getClassLoaderInstance() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return new OfficeFloorOsgiBridge(classLoader);
    }

    public OfficeFloorOsgiBridge(IJavaProject javaProject) {
        this.javaProject = javaProject;
        JavaCore.addElementChangedListener(event -> {
            this.classLoader = null;
            this.compiler = null;
        });
    }

    public OfficeFloorOsgiBridge(ClassLoader classLoader) {
        this.javaProject = null;
        this.classLoader = classLoader;
    }

    public IJavaProject getJavaProject() {
        if (this.javaProject == null) {
            throw new IllegalStateException("Instantiated to only " + ClassLoader.class.getSimpleName() + " so " + IJavaProject.class.getSimpleName() + " not available");
        }
        return this.javaProject;
    }

    public ClassLoader getClassLoader() throws Exception {
        if (this.classLoader == null) {
            String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)this.javaProject);
            URL[] urls = new URL[classPathEntries.length];
            int i = 0;
            while (i < classPathEntries.length) {
                String path = classPathEntries[i];
                File file = new File(path);
                if (file.exists()) {
                    urls[i] = file.isDirectory() ? new URL("file", null, String.valueOf(path) + "/") : new URL("file", null, path);
                }
                ++i;
            }
            this.classLoader = new URLClassLoader(urls);
        }
        return this.classLoader;
    }

    public <T> Class<? extends T> loadClass(String className, Class<T> superType) throws Exception {
        return this.getClassLoader().loadClass(className);
    }

    public boolean isClassOnClassPath(String className) throws Exception {
        if (this.javaProject == null) {
            ClassLoader classLoader = this.getClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(className);
                return clazz != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        IType type = this.javaProject.findType(className, null);
        return type != null;
    }

    public boolean isSuperType(String className, String superTypeName) throws Exception {
        if (this.javaProject == null) {
            ClassLoader classLoader = this.getClassLoader();
            Class<?> child = classLoader.loadClass(className);
            Class<?> superType = classLoader.loadClass(superTypeName);
            return superType.isAssignableFrom(child);
        }
        IType type = this.javaProject.findType(className);
        if (type == null) {
            throw new ClassNotFoundException("Class " + className + " not on class path");
        }
        IType superType = this.javaProject.findType(superTypeName);
        if (superType == null) {
            throw new ClassNotFoundException("Please add " + superTypeName + " to the class path");
        }
        ITypeHierarchy typeHierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        List<IType> superTypes = Arrays.asList(typeHierarchy.getAllSupertypes(type));
        return superTypes.stream().anyMatch(supertype -> supertype.getFullyQualifiedName().equals(superTypeName));
    }

    public String selectClass(String className, Shell parentShell, String superTypeName) throws Exception {
        return this.selectType(className, 2, parentShell, superTypeName);
    }

    public String selectType(String typeName, int consideredTypes, Shell parentShell, String superTypeName) throws Exception {
        IType superType;
        IJavaProject javaProject = this.getJavaProject();
        IJavaSearchScope scope = null;
        if (superTypeName != null && (superType = javaProject.findType(superTypeName)) != null) {
            scope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)superType, (boolean)true, (boolean)true, null);
        }
        if (scope == null) {
            scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{javaProject}, (boolean)true);
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)parentShell, (IRunnableContext)new ProgressMonitorDialog(parentShell), (IJavaSearchScope)scope, (int)consideredTypes, (boolean)false, (String)(typeName == null ? "" : typeName));
        dialog.setBlockOnOpen(true);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length != 1) {
            return null;
        }
        Object selectedItem = results[0];
        if (selectedItem instanceof IType) {
            return ((IType)selectedItem).getFullyQualifiedName();
        }
        throw new IllegalStateException("Plugin Error: selected item is not of " + IType.class.getName() + " [" + (selectedItem == null ? null : selectedItem.getClass().getName()) + "]");
    }

    public boolean isResourceOnClassPath(String resourcePath) throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        Enumeration<URL> resources = classLoader.getResources(resourcePath);
        return resources.hasMoreElements();
    }

    public String getClassPathLocation(IFile file) {
        IResource pathResource;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = pathResource = workspaceRoot.findMember(file.getFullPath());
        IJavaElement javaElement = null;
        do {
            if (resource == null) {
                return null;
            }
            javaElement = JavaCore.create((IResource)resource);
            resource = resource.getParent();
        } while (javaElement == null);
        IPackageFragmentRoot fragmentRoot = null;
        do {
            if (javaElement instanceof IPackageFragmentRoot) {
                fragmentRoot = (IPackageFragmentRoot)javaElement;
            }
            javaElement = javaElement.getParent();
        } while (fragmentRoot == null && javaElement != null);
        if (fragmentRoot == null) {
            return file.getFullPath().toString();
        }
        String fragmentPath = String.valueOf(fragmentRoot.getResource().getFullPath().toString()) + "/";
        String fullPath = file.getFullPath().toString();
        String location = fullPath.substring(fragmentPath.length());
        return location;
    }

    public String selectClassPathResource(String resourcePath, Shell parentShell) throws Exception {
        IJavaProject javaProject = this.getJavaProject();
        String filter = resourcePath == null ? "" : resourcePath;
        int index = filter.lastIndexOf(47);
        if (index >= 0) {
            filter = filter.substring(index + "/".length());
        }
        if ((index = filter.indexOf(46)) >= 0) {
            filter = filter.substring(0, index);
        }
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(parentShell, false, (IContainer)javaProject.getProject(), 1);
        dialog.setInitialPattern(filter);
        dialog.setBlockOnOpen(true);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results == null || results.length != 1) {
            return null;
        }
        Object selectedItem = results[0];
        if (selectedItem instanceof IFile) {
            IFile file = (IFile)selectedItem;
            return this.getClassPathLocation(file);
        }
        throw new IllegalStateException("Plugin Error: selected item is not of " + IFile.class.getName() + " [" + (selectedItem == null ? null : selectedItem.getClass().getName()) + "]");
    }

    public OfficeFloorCompiler getOfficeFloorCompiler() throws Exception {
        if (this.compiler == null) {
            ClassLoader classLoader = this.getClassLoader();
            this.compiler = OfficeFloorCompiler.newOfficeFloorCompiler((ClassLoader)classLoader);
        }
        return this.compiler;
    }
}

