/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.kotlin;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.officefloor.activity.procedure.build.ProcedureEmployer;
import net.officefloor.activity.procedure.spi.ProcedureListContext;
import net.officefloor.activity.procedure.spi.ProcedureMethodContext;
import net.officefloor.activity.procedure.spi.ProcedureSource;
import net.officefloor.activity.procedure.spi.ProcedureSourceServiceFactory;
import net.officefloor.frame.api.source.ServiceContext;

public class KotlinProcedureSourceServiceFactory
implements ProcedureSourceServiceFactory {
    public static final String SOURCE_NAME = "Kotlin";

    public static Class<?> getKotlinFunctions(String resource, ServiceContext context) {
        if (!resource.endsWith("Kt")) {
            return null;
        }
        return context.loadOptionalClass(resource);
    }

    public ProcedureSource createService(ServiceContext serviceContext) throws Throwable {
        return new KotlinProcedureSource(serviceContext);
    }

    private static class KotlinProcedureSource
    implements ProcedureSource {
        private final ServiceContext serviceContext;

        private KotlinProcedureSource(ServiceContext serviceContext) {
            this.serviceContext = serviceContext;
        }

        public String getSourceName() {
            return KotlinProcedureSourceServiceFactory.SOURCE_NAME;
        }

        public void listProcedures(ProcedureListContext procedureListContext) throws Exception {
            Class<?> functionsClass = KotlinProcedureSourceServiceFactory.getKotlinFunctions(procedureListContext.getResource(), this.serviceContext);
            if (functionsClass == null) {
                return;
            }
            ProcedureEmployer.listMethods(functionsClass, method -> !Modifier.isStatic(method.getModifiers()), method -> procedureListContext.addProcedure(method.getName()));
        }

        public Method loadMethod(ProcedureMethodContext procedureMethodContext) throws Exception {
            Class<?> functionClass = KotlinProcedureSourceServiceFactory.getKotlinFunctions(procedureMethodContext.getResource().getName(), this.serviceContext);
            if (functionClass == null) {
                return null;
            }
            procedureMethodContext.setMethodObjectInstanceFactory(null);
            String procedureName = procedureMethodContext.getProcedureName();
            for (Method method : functionClass.getMethods()) {
                if (!procedureName.equals(method.getName())) continue;
                return method;
            }
            return null;
        }
    }
}

