/*
 * Decompiled with CFR 0.152.
 */
package net.officefloor.jdbc.postgresql.test;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerRequestException;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.PortBinding;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.officefloor.jdbc.test.DataSourceRule;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.postgresql.ds.PGSimpleDataSource;

public class PostgreSqlRule
implements TestRule {
    private static final Set<String> pulledDockerImages = new HashSet<String>();
    private final Configuration configuration;
    private DockerClient docker;
    private String postgresContainerId;
    private final Deque<Connection> connections = new ConcurrentLinkedDeque<Connection>();

    public static void pullDockerImage(String imageName, DockerClient client) throws Exception {
        block5: {
            if (pulledDockerImages.contains(imageName)) {
                return;
            }
            try {
                Consumer<String> print = message -> {
                    System.out.print(message == null ? "" : " " + message);
                    System.out.flush();
                };
                client.pull(imageName, message -> {
                    print.accept(message.progress());
                    print.accept(message.status());
                    print.accept(message.id());
                    System.out.println();
                });
            }
            catch (DockerRequestException ex) {
                List images = client.listImages(new DockerClient.ListImagesParam[0]);
                boolean isImageExist = false;
                for (Image image : images) {
                    if (image.repoTags() == null) continue;
                    for (String tag : image.repoTags()) {
                        if (!imageName.equals(tag)) continue;
                        isImageExist = true;
                    }
                }
                if (isImageExist) break block5;
                throw ex;
            }
        }
        pulledDockerImages.add(imageName);
    }

    public PostgreSqlRule(Configuration configuration) {
        this.configuration = configuration;
    }

    public void startPostgreSql() throws Exception {
        String IMAGE_NAME = "postgres:latest";
        String CONTAINER_NAME = "officefloor_postgres";
        this.docker = DefaultDockerClient.fromEnv().build();
        for (Container container : this.docker.listContainers(new DockerClient.ListContainersParam[0])) {
            for (String name : container.names()) {
                if (!name.equals("/officefloor_postgres")) continue;
                this.postgresContainerId = container.id();
            }
        }
        if (this.postgresContainerId == null) {
            System.out.println();
            System.out.println("Starting PostgreSQL");
            PostgreSqlRule.pullDockerImage("postgres:latest", this.docker);
            String[] ports = new String[]{"5432"};
            HashMap<String, List<PortBinding>> portBindings = new HashMap<String, List<PortBinding>>();
            portBindings.put("5432", Arrays.asList(PortBinding.of((String)"0.0.0.0", (String)String.valueOf(this.configuration.port))));
            HostConfig hostConfig = HostConfig.builder().portBindings(portBindings).build();
            ContainerConfig.Builder builder = ContainerConfig.builder();
            builder = builder.hostConfig(hostConfig);
            builder = builder.image("postgres:latest");
            builder = builder.exposedPorts(ports);
            builder = builder.env(new String[]{"POSTGRES_USER=" + this.configuration.username, "POSTGRES_PASSWORD=" + this.configuration.password});
            if (this.configuration.maxConnections > 0) {
                builder = builder.cmd(new String[]{"postgres", "-N", String.valueOf(this.configuration.maxConnections)});
            }
            ContainerConfig containerConfig = builder.build();
            ContainerCreation creation = this.docker.createContainer(containerConfig, "officefloor_postgres");
            this.postgresContainerId = creation.id();
            this.docker.startContainer(this.postgresContainerId);
        }
        if (this.configuration.databaseName != null) {
            try (Connection connection = this.getConnection(null);){
                connection.createStatement().execute("DROP DATABASE IF EXISTS " + this.configuration.databaseName);
                connection.createStatement().execute("CREATE DATABASE " + this.configuration.databaseName);
            }
        }
    }

    public Connection getConnection() throws Exception {
        return this.getConnection(this.configuration.databaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(String databaseName) throws Exception {
        PGSimpleDataSource dataSource = new PGSimpleDataSource();
        dataSource.setPortNumber(this.configuration.port);
        dataSource.setUser(this.configuration.username);
        dataSource.setPassword(this.configuration.password);
        if (databaseName != null) {
            dataSource.setDatabaseName(databaseName);
        }
        Logger logger = Logger.getLogger("org.postgresql");
        Level level = logger.getLevel();
        try {
            logger.setLevel(Level.OFF);
            logger.setUseParentHandlers(false);
            Connection connection = DataSourceRule.waitForDatabaseAvailable(context -> context.setConnection(dataSource.getConnection()));
            this.connections.push(connection);
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            logger.setLevel(level);
        }
    }

    public void stopPostgreSql() throws Exception {
        for (Connection connection : this.connections) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
        System.out.println("Stopping PostgreSQL");
        this.docker.killContainer(this.postgresContainerId);
        this.docker.removeContainer(this.postgresContainerId);
        this.docker.close();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (PostgreSqlRule.this.configuration.server != null) {
                    InetAddress address;
                    try {
                        address = InetAddress.getByName(PostgreSqlRule.this.configuration.server);
                    }
                    catch (Throwable ex) {
                        throw new IllegalStateException("INVALID SETUP: need to configure " + PostgreSqlRule.this.configuration.server + " as loop back (127.0.0.1)", ex);
                    }
                    Assert.assertTrue((String)("INVALID SETUP: dns " + PostgreSqlRule.this.configuration.server + " must be configured as loop back (127.0.0.1)"), (boolean)address.isLoopbackAddress());
                }
                PostgreSqlRule.this.startPostgreSql();
                try {
                    base.evaluate();
                }
                finally {
                    PostgreSqlRule.this.stopPostgreSql();
                }
            }
        };
    }

    public static class Configuration {
        private String server = "localhost";
        private int port = 5432;
        private String databaseName = null;
        private String username = "testuser";
        private String password = "testpassword";
        private int maxConnections = 0;

        public Configuration server(String server) {
            this.server = server;
            return this;
        }

        public Configuration port(int port) {
            this.port = port;
            return this;
        }

        public Configuration database(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Configuration username(String username) {
            this.username = username;
            return this;
        }

        public Configuration password(String password) {
            this.password = password;
            return this;
        }

        public Configuration maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }
    }
}

