/*
 * Decompiled with CFR 0.152.
 */
package org.unitedinternet.cosmo.model;

import java.util.Comparator;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedinternet.cosmo.model.AuditableObject;

public class AuditableComparator
implements Comparator<AuditableObject> {
    private static Log log = LogFactory.getLog(AuditableComparator.class);
    public static final int ATTRIBUTE_CREATED = 0;
    public static final int ATTRIBUTE_MODIFIED = 1;
    private boolean reverse;
    private int attribute;

    public AuditableComparator() {
        this(false, 1);
    }

    public AuditableComparator(boolean reverse) {
        this(reverse, 1);
    }

    public AuditableComparator(int attribute) {
        this(false, attribute);
    }

    public AuditableComparator(boolean reverse, int attribute) {
        if (!AuditableComparator.supports(attribute)) {
            throw new IllegalArgumentException("unknown attribute " + attribute);
        }
        this.reverse = reverse;
        this.attribute = attribute;
    }

    @Override
    public int compare(AuditableObject o1, AuditableObject o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        if (this.attribute == 0) {
            return this.compare(o1.getCreationDate(), o2.getCreationDate());
        }
        return this.compare(o1.getModifiedDate(), o2.getModifiedDate());
    }

    @Override
    protected int compare(Date d1, Date d2) {
        if (d1.after(d2)) {
            return this.reverse ? -1 : 1;
        }
        return this.reverse ? 1 : -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof AuditableComparator) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return 1;
    }

    public static boolean supports(int attribute) {
        return attribute == 0 || attribute == 1;
    }
}

