/*
 * Decompiled with CFR 0.152.
 */
package org.unitedinternet.cosmo.model;

import java.io.Serializable;
import java.util.Comparator;
import org.unitedinternet.cosmo.model.BaseEventStamp;
import org.unitedinternet.cosmo.model.NoteItem;
import org.unitedinternet.cosmo.model.NoteOccurrence;
import org.unitedinternet.cosmo.model.StampUtils;

public class NoteItemTriageStatusComparator
implements Comparator<NoteItem>,
Serializable {
    boolean reverse = false;

    public NoteItemTriageStatusComparator() {
    }

    public NoteItemTriageStatusComparator(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public int compare(NoteItem note1, NoteItem note2) {
        long rank2;
        if (note1.getUid().equals(note2.getUid())) {
            return 0;
        }
        long rank1 = this.getRank(note1);
        if (rank1 > (rank2 = this.getRank(note2))) {
            return this.reverse ? -1 : 1;
        }
        return this.reverse ? 1 : -1;
    }

    private long getRank(NoteItem note) {
        if (note.getTriageStatus() != null && note.getTriageStatus().getRank() != null) {
            return note.getTriageStatus().getRank().scaleByPowerOfTen(3).longValue();
        }
        BaseEventStamp eventStamp = StampUtils.getBaseEventStamp(note);
        if (eventStamp != null) {
            return eventStamp.getStartDate().getTime() * -1L;
        }
        if (note instanceof NoteOccurrence) {
            return ((NoteOccurrence)note).getOccurrenceDate().getTime() * -1L;
        }
        return note.getModifiedDate().getTime() * -1L;
    }
}

