/*
 * Decompiled with CFR 0.152.
 */
package org.unitedinternet.cosmo.model;

import java.util.HashSet;
import java.util.Set;

public class TicketType {
    public static final String PRIVILEGE_READ = "read";
    public static final String PRIVILEGE_WRITE = "write";
    public static final String PRIVILEGE_FREEBUSY = "freebusy";
    public static final String ID_READ_ONLY = "read-only";
    public static final TicketType READ_ONLY = new TicketType("read-only", new String[]{"read", "freebusy"});
    public static final String ID_READ_WRITE = "read-write";
    public static final TicketType READ_WRITE = new TicketType("read-write", new String[]{"read", "write", "freebusy"});
    public static final String ID_FREE_BUSY = "free-busy";
    public static final TicketType FREE_BUSY = new TicketType("free-busy", new String[]{"freebusy"});
    private String id;
    private Set<String> privileges;

    public TicketType(String id) {
        this.id = id;
        this.privileges = new HashSet<String>();
    }

    public TicketType(String id, String[] privileges) {
        this(id);
        for (String p : privileges) {
            this.privileges.add(p);
        }
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getPrivileges() {
        return this.privileges;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TicketType)) {
            return false;
        }
        return this.id.equals(((TicketType)o).id);
    }

    public int hashCode() {
        return 1;
    }

    public static TicketType createInstance(String id) {
        if (id.equals(ID_READ_ONLY)) {
            return READ_ONLY;
        }
        if (id.equals(ID_READ_WRITE)) {
            return READ_WRITE;
        }
        if (id.equals(ID_FREE_BUSY)) {
            return FREE_BUSY;
        }
        return new TicketType(id);
    }

    public static boolean isKnownType(String id) {
        return id.equals(ID_READ_ONLY) || id.equals(ID_READ_WRITE) || id.equals(ID_FREE_BUSY);
    }
}

