/*
 * Decompiled with CFR 0.152.
 */
package org.unitedinternet.cosmo.model;

import java.math.BigDecimal;
import java.util.Date;
import org.unitedinternet.cosmo.model.TriageStatus;

public class TriageStatusUtil {
    public static String label(Integer code) {
        if (code.equals(100)) {
            return "NOW";
        }
        if (code.equals(200)) {
            return "LATER";
        }
        if (code.equals(300)) {
            return "DONE";
        }
        throw new IllegalStateException("Unknown code " + code);
    }

    public static Integer code(String label) {
        if (label.equals("NOW")) {
            return 100;
        }
        if (label.equals("LATER")) {
            return 200;
        }
        if (label.equals("DONE")) {
            return 300;
        }
        throw new IllegalStateException("Unknown label " + label);
    }

    public static TriageStatus initialize(TriageStatus ts) {
        ts.setCode(100);
        ts.setRank(TriageStatusUtil.getRank(System.currentTimeMillis()));
        ts.setAutoTriage(Boolean.TRUE);
        return ts;
    }

    public static BigDecimal getRank(long date) {
        String time = date / 1000L + ".00";
        return new BigDecimal(time).negate();
    }

    public static Date getDateFromRank(BigDecimal rank) {
        return new Date(rank.negate().scaleByPowerOfTen(3).longValue());
    }
}

