/*
 * Decompiled with CFR 0.152.
 */
package org.unitedinternet.cosmo.model;

import java.util.Set;
import org.unitedinternet.cosmo.model.AuditableObject;
import org.unitedinternet.cosmo.model.CollectionSubscription;
import org.unitedinternet.cosmo.model.Preference;

public interface User
extends AuditableObject {
    public static final String USERNAME_OVERLORD = "root";
    public static final String NAME_SORT_STRING = "Name";
    public static final String USERNAME_SORT_STRING = "Username";
    public static final String ADMIN_SORT_STRING = "Administrator";
    public static final String EMAIL_SORT_STRING = "Email";
    public static final String CREATED_SORT_STRING = "Created";
    public static final String LAST_MODIFIED_SORT_STRING = "Last Modified";
    public static final String ACTIVATED_SORT_STRING = "Activated";
    public static final String LOCKED_SORT_STRING = "Locked";
    public static final String DEFAULT_SORT_STRING = "Name";
    public static final String NAME_URL_STRING = "name";
    public static final String USERNAME_URL_STRING = "username";
    public static final String ADMIN_URL_STRING = "admin";
    public static final String EMAIL_URL_STRING = "email";
    public static final String CREATED_URL_STRING = "created";
    public static final String LAST_MODIFIED_URL_STRING = "modified";
    public static final String ACTIVATED_URL_STRING = "activated";
    public static final String LOCKED_URL_STRING = "locked";
    public static final int PASSWORD_LEN_MIN = 5;
    public static final int PASSWORD_LEN_MAX = 16;

    public String getUid();

    public void setUid(String var1);

    public String getUsername();

    public void setUsername(String var1);

    public String getOldUsername();

    public boolean isUsernameChanged();

    public String getPassword();

    public void setPassword(String var1);

    public String getFirstName();

    public void setFirstName(String var1);

    public String getLastName();

    public void setLastName(String var1);

    public String getEmail();

    public void setEmail(String var1);

    public String getOldEmail();

    public boolean isEmailChanged();

    public Boolean getAdmin();

    public Boolean getOldAdmin();

    public boolean isAdminChanged();

    public void setAdmin(Boolean var1);

    public String getActivationId();

    public void setActivationId(String var1);

    public boolean isOverlord();

    public boolean isActivated();

    public void activate();

    public Boolean isLocked();

    public void setLocked(Boolean var1);

    public void validateRawPassword();

    public Set<Preference> getPreferences();

    public void addPreference(Preference var1);

    public Preference getPreference(String var1);

    public void removePreference(String var1);

    public void removePreference(Preference var1);

    public String calculateEntityTag();

    public Set<CollectionSubscription> getSubscriptions();

    public static enum SortType {
        NAME("name", "Name"),
        USERNAME("username", "Username"),
        ADMIN("admin", "Administrator"),
        EMAIL("email", "Email"),
        CREATED("created", "Created"),
        LAST_MODIFIED("modified", "Last Modified"),
        ACTIVATED("activated", "Activated"),
        LOCKED("locked", "Locked");

        private final String urlString;
        private final String titleString;

        private SortType(String urlString, String titleString) {
            this.urlString = urlString;
            this.titleString = titleString;
        }

        public String getTitleString() {
            return this.titleString;
        }

        public String getUrlString() {
            return this.urlString;
        }

        public static SortType getByUrlString(String string) {
            if (string.equals(User.NAME_URL_STRING)) {
                return NAME;
            }
            if (string.equals(User.USERNAME_URL_STRING)) {
                return USERNAME;
            }
            if (string.equals(User.ADMIN_URL_STRING)) {
                return ADMIN;
            }
            if (string.equals(User.EMAIL_URL_STRING)) {
                return EMAIL;
            }
            if (string.equals(User.CREATED_URL_STRING)) {
                return CREATED;
            }
            if (string.equals(User.LAST_MODIFIED_URL_STRING)) {
                return LAST_MODIFIED;
            }
            if (string.equals(User.ACTIVATED_URL_STRING)) {
                return ACTIVATED;
            }
            if (string.equals(User.LOCKED_URL_STRING)) {
                return LOCKED;
            }
            return null;
        }
    }
}

