/*
 * Decompiled with CFR 0.152.
 */
package org.unitedinternet.cosmo.model.filter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.Dates;
import net.fortuna.ical4j.util.TimeZones;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitedinternet.cosmo.model.BaseEventStamp;
import org.unitedinternet.cosmo.model.filter.StampFilter;

public class EventStampFilter
extends StampFilter {
    public static final String PROPERTY_INCLUDE_MASTER_ITEMS = "cosmo.filter.eventStamp.timeRange.includeMasterItems";
    public static final String PROPERTY_DO_TIMERANGE_SECOND_PASS = "cosmo.filter.eventStamp.timeRange.doSecondPass";
    private static final Log LOG = LogFactory.getLog(EventStampFilter.class);
    private Period period = null;
    private Boolean isRecurring = null;
    private DateTime dstart;
    private DateTime dend;
    private Date fstart;
    private Date fend;
    private TimeZone timezone = null;
    private boolean expandRecurringEvents = false;

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
        this.dstart = period.getStart();
        this.dend = period.getEnd();
        this.updateFloatingTimes();
    }

    public void setTimeRange(Date start, Date end) {
        this.dstart = EventStampFilter.utc(start);
        this.dend = EventStampFilter.utc(end);
        this.fstart = start;
        this.fend = end;
        this.updateFloatingTimes();
        this.period = new Period(this.dstart, this.dend);
    }

    public String getUTCStart() {
        return this.dstart.toString();
    }

    public String getUTCStart(String dateTimeFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
        sdf.setTimeZone(TimeZones.getUtcTimeZone());
        return sdf.format((Date)this.dstart);
    }

    public String getUTCEnd() {
        return this.dend.toString();
    }

    public String getUTCEnd(String dateTimeFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
        sdf.setTimeZone(TimeZones.getUtcTimeZone());
        return sdf.format((Date)this.dend);
    }

    public String getFloatStart(String dateTimeFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
        return sdf.format(this.fstart);
    }

    public String getFloatStart() {
        return this.fstart.toString();
    }

    public String getFloatEnd() {
        return this.fend.toString();
    }

    public String getFloatEnd(String dateTimeFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat);
        return sdf.format(this.fend);
    }

    public boolean isExpandRecurringEvents() {
        return this.expandRecurringEvents;
    }

    public void setExpandRecurringEvents(boolean expandRecurringEvents) {
        this.expandRecurringEvents = expandRecurringEvents;
    }

    public EventStampFilter() {
        this.setStampClass(BaseEventStamp.class);
    }

    public TimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        this.timezone = timezone;
        this.updateFloatingTimes();
    }

    public Boolean getIsRecurring() {
        return this.isRecurring;
    }

    public void setIsRecurring(Boolean isRecurring) {
        this.isRecurring = isRecurring;
    }

    private void updateFloatingTimes() {
        Value v;
        if (this.dstart != null) {
            v = Value.DATE_TIME;
            Date date = this.fstart = this.fstart == null ? (DateTime)Dates.getInstance((Date)this.dstart, (Value)v) : this.fstart;
            if (this.fstart instanceof DateTime) {
                ((DateTime)this.fstart).setUtc(false);
                ((DateTime)this.fstart).setTimeZone(this.timezone != null ? this.timezone : null);
            }
        }
        if (this.dend != null) {
            v = Value.DATE_TIME;
            Date date = this.fend = this.fend == null ? (DateTime)Dates.getInstance((Date)this.dend, (Value)v) : this.fend;
            if (this.fend instanceof DateTime) {
                ((DateTime)this.fend).setUtc(false);
                ((DateTime)this.fend).setTimeZone(this.timezone != null ? this.timezone : null);
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        TimeZone tz = this.getTimezone();
        if (tz != null) {
            df.setTimeZone(java.util.TimeZone.getTimeZone(tz.getID()));
        }
        if (this.fstart != null && this.fstart.getClass() == net.fortuna.ical4j.model.Date.class) {
            try {
                this.dstart = new DateTime(df.parse(this.fstart.toString()).getTime());
                this.dstart.setUtc(true);
            }
            catch (ParseException e) {
                LOG.error((Object)("Error occured while parsing fstart [" + this.fstart.toString() + "]"), (Throwable)e);
            }
        }
        if (this.fend != null && this.fend.getClass() == net.fortuna.ical4j.model.Date.class) {
            try {
                this.dend = new DateTime(df.parse(this.fend.toString()).getTime());
                this.dend.setUtc(true);
            }
            catch (ParseException e) {
                LOG.error((Object)("Error occured while parsing fend [" + this.fend.toString() + "]"), (Throwable)e);
            }
        }
    }

    private static DateTime utc(Date date) {
        DateTime dt = new DateTime(date);
        dt.setUtc(true);
        return dt;
    }
}

