/*
 * Decompiled with CFR 0.152.
 */
package net.openesb.admin.rest.api;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.DatatypeConverter;

@Provider
@PreMatching
public class ContainerBasedAuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger log = Logger.getLogger(ContainerBasedAuthenticationFilter.class.getName());
    @Context
    HttpServletRequest request;

    public void filter(ContainerRequestContext requestCtx) throws IOException {
        if (requestCtx.getRequest().getMethod().equals("OPTIONS")) {
            requestCtx.abortWith(Response.status((Response.Status)Response.Status.OK).build());
        } else {
            try {
                String requestUriPath;
                String usernamePassword;
                String username = "";
                String password = "";
                String authorization = this.request.getHeader("authorization");
                if (null != authorization && authorization.length() > "Basic ".length() && (usernamePassword = new String(DatatypeConverter.parseBase64Binary((String)authorization.substring("Basic ".length())))).contains(":")) {
                    username = usernamePassword.substring(0, usernamePassword.indexOf(":"));
                    if (usernamePassword.indexOf(":") + 1 < usernamePassword.length()) {
                        password = usernamePassword.substring(usernamePassword.indexOf(":") + 1);
                    }
                }
                try {
                    this.request.login(username, password);
                }
                catch (ServletException ex) {
                    log.log(Level.SEVERE, "Unexpected error while login", ex);
                    requestCtx.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                    return;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "The authenticated user is in role: {0}", this.request.isUserInRole("oeadmin"));
                    log.log(Level.FINEST, "The authenticated remote username: {0}", this.request.getRemoteUser());
                    log.log(Level.FINEST, "The authenticated Principal name: {0}", this.request.getUserPrincipal());
                    log.log(Level.FINEST, "The authentication type: {0}", this.request.getAuthType());
                }
                if ((requestUriPath = requestCtx.getUriInfo().getRequestUri().getPath()).endsWith("/login")) {
                    requestCtx.abortWith(Response.status((Response.Status)Response.Status.OK).build());
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.request.logout();
                }
                catch (ServletException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

