/*
 *     Copyright (C) 2015  higherfrequencytrading.com
 *
 *     This program is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Lesser General Public License for more details.
 *
 *     You should have received a copy of the GNU Lesser General Public License
 *     along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.openhft.chronicle.engine.cfg;

import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.fs.Clusters;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

/**
 * Created by peter on 26/08/15.
 */
public class ClustersCfg implements Installable, Marshallable {
    final Clusters clusters = new Clusters();

    @Override
    public ClustersCfg install(String path, AssetTree assetTree) throws Exception {
        assetTree.root().addView(Clusters.class, clusters);

        return this;
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        clusters.readMarshallable(wire);
    }

    @Override
    public void writeMarshallable(WireOut wire) {
        clusters.writeMarshallable(wire);
    }

    @Override
    public String toString() {
        return "ClustersCfg{" +
                "clusters=" + clusters +
                '}';
    }
}
