/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash;

import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import org.jetbrains.annotations.Nullable;

public interface Data<V> {
    public RandomDataInput bytes();

    public long offset();

    public long size();

    default public long hash(LongHashFunction f) {
        return f.hash((Object)this.bytes(), Access.checkedRandomDataInputAccess(), this.offset(), this.size());
    }

    default public boolean equivalent(RandomDataInput source, long sourceOffset) {
        return BytesUtil.bytesEqual((RandomDataInput)source, (long)sourceOffset, (RandomDataInput)this.bytes(), (long)this.offset(), (long)this.size());
    }

    default public void writeTo(RandomDataOutput target, long targetOffset) {
        target.write(targetOffset, this.bytes(), this.offset(), this.size());
    }

    public V get();

    public V getUsing(@Nullable V var1);

    public static boolean bytesEquivalent(Data<?> d1, Data<?> d2) {
        if (d1.size() != d2.size()) {
            return false;
        }
        return BytesUtil.bytesEqual((RandomDataInput)d1.bytes(), (long)d1.offset(), (RandomDataInput)d2.bytes(), (long)d2.offset(), (long)d1.size());
    }
}

