/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.hashing;

import java.lang.reflect.Field;
import net.openhft.chronicle.hash.hashing.LongHashFunction;
import net.openhft.chronicle.hash.hashing.StringHash;
import net.openhft.chronicle.hash.hashing.UnsafeAccess;

enum ModernHotSpotStringHash implements StringHash
{
    INSTANCE;

    private static final long valueOffset;

    @Override
    public long longHash(String s, LongHashFunction hashFunction, int off, int len) {
        char[] value = (char[])UnsafeAccess.UNSAFE.getObject(s, valueOffset);
        return hashFunction.hashChars(value, off, len);
    }

    static {
        try {
            Field valueField = String.class.getDeclaredField("value");
            valueOffset = UnsafeAccess.UNSAFE.objectFieldOffset(valueField);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }
}

