/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.openhft.chronicle.hash.KeyContext;
import net.openhft.chronicle.hash.replication.AbstractReplication;
import net.openhft.chronicle.hash.replication.ReplicableEntry;
import net.openhft.chronicle.hash.replication.TimeProvider;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.map.ChronicleMapBuilder;
import net.openhft.chronicle.map.Replica;
import net.openhft.chronicle.map.VanillaChronicleMap;
import net.openhft.chronicle.map.impl.CompiledReplicatedMapIterationContext;
import net.openhft.chronicle.map.impl.CompiledReplicatedMapQueryContext;
import net.openhft.chronicle.map.impl.IterationContextInterface;
import net.openhft.chronicle.map.impl.QueryContextInterface;
import net.openhft.chronicle.map.replication.MapRemoteOperations;
import net.openhft.chronicle.map.replication.MapReplicableEntry;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.SingleThreadedDirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedChronicleMap<K, KI, MKI extends MetaBytesInterop<K, ? super KI>, V, VI, MVI extends MetaBytesInterop<V, ? super VI>, R>
extends VanillaChronicleMap<K, KI, MKI, V, VI, MVI, R>
implements Replica,
Replica.EntryExternalizable {
    public static final int RESERVED_MOD_ITER = 8;
    public static final int ADDITIONAL_ENTRY_BYTES = 10;
    private static final long serialVersionUID = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatedChronicleMap.class);
    private static final long LAST_UPDATED_HEADER_SIZE = 1024L;
    public final TimeProvider timeProvider;
    private final byte localIdentifier;
    transient Set<Closeable> closeables;
    private transient Bytes identifierUpdatedBytes;
    private transient ATSDirectBitSet modIterSet;
    private transient AtomicReferenceArray<ModificationIterator> modificationIterators;
    private transient long startOfModificationIterators;
    private boolean bootstrapOnlyLocalEntries;
    public transient MapRemoteOperations<K, V, R> remoteOperations;
    transient CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> remoteOpContext;
    transient CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?> remoteItContext;

    public ReplicatedChronicleMap(@NotNull ChronicleMapBuilder<K, V> builder, AbstractReplication replication) throws IOException {
        super(builder, true);
        this.timeProvider = builder.timeProvider();
        this.remoteOperations = builder.remoteOperations;
        this.localIdentifier = replication.identifier();
        this.bootstrapOnlyLocalEntries = replication.bootstrapOnlyLocalEntries();
        if (this.localIdentifier == -1) {
            throw new IllegalStateException("localIdentifier should not be -1");
        }
    }

    @Override
    void initQueryContext() {
        this.queryCxt = new ThreadLocal<CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?>>(){

            @Override
            protected CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> initialValue() {
                return new CompiledReplicatedMapQueryContext(ReplicatedChronicleMap.this);
            }
        };
    }

    @Override
    void initIterationContext() {
        this.iterCxt = new ThreadLocal<CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?>>(){

            @Override
            protected CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?> initialValue() {
                return new CompiledReplicatedMapIterationContext(ReplicatedChronicleMap.this);
            }
        };
    }

    private int assignedModIterBitSetSizeInBytes() {
        return (int)MemoryUnit.CACHE_LINES.align(MemoryUnit.BYTES.alignAndConvert(135L, MemoryUnit.BITS), MemoryUnit.BYTES);
    }

    @Override
    public void initTransients() {
        super.initTransients();
        this.ownInitTransients();
    }

    private void ownInitTransients() {
        this.modificationIterators = new AtomicReferenceArray(135);
        this.closeables = new CopyOnWriteArraySet<Closeable>();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.ownInitTransients();
    }

    long modIterBitSetSizeInBytes() {
        long bytes = MemoryUnit.BITS.toBytes(this.bitsPerSegmentInModIterBitSet() * (long)this.actualSegments);
        return MemoryUnit.CACHE_LINES.align(bytes, MemoryUnit.BYTES);
    }

    private long bitsPerSegmentInModIterBitSet() {
        return Maths.nextPower2((long)this.actualChunksPerSegment, (long)1024L);
    }

    @Override
    public long mapHeaderInnerSize() {
        return super.mapHeaderInnerSize() + 1024L + this.modIterBitSetSizeInBytes() * 136L + (long)this.assignedModIterBitSetSizeInBytes();
    }

    public void setLastModificationTime(byte identifier, long timestamp) {
        long offset = (long)identifier * 8L;
        if (this.identifierUpdatedBytes.readLong(offset) < timestamp) {
            this.identifierUpdatedBytes.writeLong(offset, timestamp);
        }
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        assert (remoteIdentifier != this.identifier());
        return this.identifierUpdatedBytes.readLong((long)remoteIdentifier * 8L);
    }

    @Override
    public void onHeaderCreated() {
        long offset = super.mapHeaderInnerSize();
        this.identifierUpdatedBytes = this.ms.bytes(offset, 1024L).zeroOut();
        Bytes modDelBytes = this.ms.bytes(offset += 1024L, (long)this.assignedModIterBitSetSizeInBytes()).zeroOut();
        this.startOfModificationIterators = offset += (long)this.assignedModIterBitSetSizeInBytes();
        this.modIterSet = new ATSDirectBitSet(modDelBytes);
    }

    @Override
    public void clear() {
        this.forEachEntry(KeyContext::remove);
    }

    void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void close() {
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        }
        super.close();
    }

    @Override
    public byte identifier() {
        return this.localIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Replica.ModificationIterator acquireModificationIterator(byte remoteIdentifier, @NotNull Replica.ModificationNotifier modificationNotifier) {
        ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
        if (modificationIterator != null) {
            return modificationIterator;
        }
        AtomicReferenceArray<ModificationIterator> atomicReferenceArray = this.modificationIterators;
        synchronized (atomicReferenceArray) {
            modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            Bytes bytes = this.ms.bytes(this.startOfModificationIterators + this.modIterBitSetSizeInBytes() * (long)remoteIdentifier, this.modIterBitSetSizeInBytes());
            ModificationIterator newModificationIterator = new ModificationIterator(bytes, modificationNotifier);
            this.modificationIterators.set(remoteIdentifier, newModificationIterator);
            this.modIterSet.set((long)remoteIdentifier);
            return newModificationIterator;
        }
    }

    public void raiseChange(long segmentIndex, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.modificationIterators.get((int)next).raiseChange(segmentIndex, pos);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    public void dropChange(long segmentIndex, long pos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                this.modificationIterators.get((int)next).dropChange(segmentIndex, pos);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    public void moveChange(long segmentIndex, long oldPos, long newPos) {
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            try {
                ModificationIterator modificationIterator = this.modificationIterators.get((int)next);
                if (modificationIterator.dropChange(segmentIndex, oldPos)) {
                    modificationIterator.raiseChange(segmentIndex, newPos);
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    @Override
    public boolean identifierCheck(@NotNull ReplicableEntry entry, int chronicleId) {
        return entry.originIdentifier() == this.localIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sizeOfEntry(@NotNull Bytes entry, int chronicleId) {
        long start = entry.position();
        try {
            long keySize = this.keySizeMarshaller.readSize(entry);
            entry.skip(keySize + 8L);
            byte identifier = entry.readByte();
            if (identifier != this.localIdentifier) {
                int n = 0;
                return n;
            }
            entry.skip(1L);
            long valueSize = this.valueSizeMarshaller.readSize(entry);
            this.alignment.alignPositionAddr(entry);
            long result = entry.position() + valueSize - start;
            assert (result < Integer.MAX_VALUE);
            int n = (int)result;
            return n;
        }
        finally {
            entry.position(start);
        }
    }

    @Override
    public void writeExternalEntry(@NotNull Bytes entry, @NotNull Bytes destination, int chronicleId) {
        long keySize = this.keySizeMarshaller.readSize(entry);
        long keyPosition = entry.position();
        entry.skip(keySize);
        long timeStamp = entry.readLong();
        byte identifier = entry.readByte();
        if (identifier != this.localIdentifier) {
            return;
        }
        boolean isDeleted = entry.readBoolean();
        long valueSize = !isDeleted ? this.valueSizeMarshaller.readSize(entry) : this.valueSizeMarshaller.minEncodableSize();
        long valuePosition = entry.position();
        this.keySizeMarshaller.writeSize(destination, keySize);
        this.valueSizeMarshaller.writeSize(destination, valueSize);
        destination.writeStopBit(timeStamp);
        if (identifier == 0) {
            throw new IllegalStateException("Identifier can't be 0");
        }
        destination.writeByte((int)identifier);
        destination.writeBoolean(isDeleted);
        entry.position(keyPosition);
        destination.write((RandomDataInput)entry, entry.position(), keySize);
        boolean debugEnabled = LOG.isDebugEnabled();
        String message = null;
        if (debugEnabled) {
            if (isDeleted) {
                LOG.debug("WRITING ENTRY TO DEST -  into local-id={}, remove(key={})", (Object)this.localIdentifier, (Object)entry.toString().trim());
            } else {
                message = String.format("WRITING ENTRY TO DEST  -  into local-id=%d, put(key=%s,", this.localIdentifier, entry.toString().trim());
            }
        }
        if (isDeleted) {
            return;
        }
        entry.position(valuePosition);
        this.alignment.alignPositionAddr(entry);
        destination.write((RandomDataInput)entry, entry.position(), valueSize);
        if (debugEnabled) {
            LOG.debug(message + "value=" + entry.toString().trim() + ")");
        }
    }

    private CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> q() {
        return (CompiledReplicatedMapQueryContext)this.queryCxt.get();
    }

    public CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> mapContext() {
        CompiledReplicatedMapQueryContext q = (CompiledReplicatedMapQueryContext)this.q().getContext();
        q.initUsed(true);
        return q;
    }

    private CompiledReplicatedMapQueryContext<K, KI, MKI, V, VI, MVI, R, ?> remoteOpContext() {
        if (this.remoteOpContext == null) {
            this.remoteOpContext = this.q();
        }
        assert (!this.remoteOpContext.usedInit());
        this.remoteOpContext.initUsed(true);
        return this.remoteOpContext;
    }

    private CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?> remoteItContext() {
        if (this.remoteItContext == null) {
            this.remoteItContext = this.i();
        }
        assert (!this.remoteItContext.usedInit());
        this.remoteItContext.initUsed(true);
        return this.remoteItContext;
    }

    @Override
    public void readExternalEntry(@NotNull Bytes source) {
        try (QueryContextInterface remoteOpContext = this.mapContext();){
            ((CompiledReplicatedMapQueryContext)remoteOpContext).initReplicationInput(source);
            ((CompiledReplicatedMapQueryContext)remoteOpContext).processReplicatedEvent();
        }
    }

    private CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?> i() {
        return (CompiledReplicatedMapIterationContext)this.iterCxt.get();
    }

    public CompiledReplicatedMapIterationContext<K, KI, MKI, V, VI, MVI, R, ?> iterationContext() {
        CompiledReplicatedMapIterationContext c = (CompiledReplicatedMapIterationContext)this.i().getContext();
        c.initUsed(true);
        return c;
    }

    class ModificationIterator
    implements Replica.ModificationIterator {
        private final Replica.ModificationNotifier modificationNotifier;
        private final SingleThreadedDirectBitSet changesForUpdates;
        private final ATSDirectBitSet changesForIteration;
        private final int segmentIndexShift;
        private final long posMask;
        private volatile long position = -1L;

        public ModificationIterator(@NotNull Bytes bytes, Replica.ModificationNotifier modificationNotifier) {
            this.modificationNotifier = modificationNotifier;
            long bitsPerSegment = ReplicatedChronicleMap.this.bitsPerSegmentInModIterBitSet();
            this.segmentIndexShift = Long.numberOfTrailingZeros(bitsPerSegment);
            this.posMask = bitsPerSegment - 1L;
            this.changesForUpdates = new SingleThreadedDirectBitSet(bytes);
            this.changesForIteration = new ATSDirectBitSet(bytes);
        }

        private long combine(long segmentIndex, long pos) {
            return segmentIndex << this.segmentIndexShift | pos;
        }

        void raiseChange(long segmentIndex, long pos) {
            LOG.debug("raise change: id {}, segment {}, pos {}", new Object[]{ReplicatedChronicleMap.this.localIdentifier, segmentIndex, pos});
            this.changesForUpdates.set(this.combine(segmentIndex, pos));
            this.modificationNotifier.onChange();
        }

        boolean dropChange(long segmentIndex, long pos) {
            LOG.debug("drop change: id {}, segment {}, pos {}", new Object[]{ReplicatedChronicleMap.this.localIdentifier, segmentIndex, pos});
            return this.changesForUpdates.clearIfSet(this.combine(segmentIndex, pos));
        }

        @Override
        public boolean hasNext() {
            long position = this.position;
            return this.changesForIteration.nextSetBit(position == -1L ? 0L : position) != -1L || position > 0L && this.changesForIteration.nextSetBit(0L) != -1L;
        }

        @Override
        public boolean nextEntry(@NotNull Replica.EntryCallback entryCallback, int chronicleId) {
            long position = this.position;
            while (true) {
                long oldPosition;
                if ((position = this.changesForIteration.nextSetBit((oldPosition = position) + 1L)) == -1L) {
                    if (oldPosition != -1L) continue;
                    this.position = -1L;
                    return false;
                }
                this.position = position;
                int segmentIndex = (int)(position >>> this.segmentIndexShift);
                IterationContextInterface context = ReplicatedChronicleMap.this.iterationContext();
                Throwable throwable = null;
                try {
                    ((CompiledReplicatedMapIterationContext)context).initTheSegmentIndex(segmentIndex);
                    ((CompiledReplicatedMapIterationContext)context).updateLock().lock();
                    if (!this.changesForUpdates.get(position)) continue;
                    entryCallback.onBeforeEntry();
                    long segmentPos = position & this.posMask;
                    ((CompiledReplicatedMapIterationContext)context).readExistingEntry(segmentPos);
                    if (entryCallback.shouldBeIgnored((ReplicableEntry)((Object)context), chronicleId)) {
                        this.changesForUpdates.clear(position);
                        continue;
                    }
                    ((CompiledReplicatedMapIterationContext)context).entryBytes().limit(((CompiledReplicatedMapIterationContext)context).valueOffset() + ((CompiledReplicatedMapIterationContext)context).valueSize());
                    ((CompiledReplicatedMapIterationContext)context).entryBytes().position(((CompiledReplicatedMapIterationContext)context).keySizeOffset());
                    boolean success = entryCallback.onEntry(((CompiledReplicatedMapIterationContext)context).entryBytes(), chronicleId);
                    entryCallback.onAfterEntry();
                    if (success) {
                        this.changesForUpdates.clear(position);
                    }
                    boolean bl = success;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            ((CompiledReplicatedMapIterationContext)context).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((CompiledReplicatedMapIterationContext)context).close();
                    continue;
                }
                break;
            }
        }

        @Override
        public void dirtyEntries(long fromTimeStamp) {
            try (IterationContextInterface c = ReplicatedChronicleMap.this.iterationContext();){
                boolean debugEnabled = LOG.isDebugEnabled();
                int i = 0;
                while (i < ReplicatedChronicleMap.this.actualSegments) {
                    int segmentIndex = i++;
                    ((CompiledReplicatedMapIterationContext)c).initTheSegmentIndex(segmentIndex);
                    ((CompiledReplicatedMapIterationContext)c).forEachReplicableEntry(arg_0 -> this.lambda$dirtyEntries$10(debugEnabled, (CompiledReplicatedMapIterationContext)c, fromTimeStamp, segmentIndex, arg_0));
                }
            }
        }

        private /* synthetic */ void lambda$dirtyEntries$10(boolean bl, CompiledReplicatedMapIterationContext compiledReplicatedMapIterationContext, long l, int n, ReplicableEntry entry) {
            if (bl) {
                LOG.debug("Bootstrap entry: id {}, key {}, value {}", new Object[]{ReplicatedChronicleMap.this.localIdentifier, compiledReplicatedMapIterationContext.key(), compiledReplicatedMapIterationContext.value()});
            }
            MapReplicableEntry re = (MapReplicableEntry)entry;
            assert (re.originTimestamp() > 0L);
            if (bl) {
                LOG.debug("Bootstrap decision: bs ts: {}, entry ts: {}, entry id: {}, local id: {}", new Object[]{l, re.originTimestamp(), re.originIdentifier(), ReplicatedChronicleMap.this.localIdentifier});
            }
            if (!(re.originTimestamp() < l || ReplicatedChronicleMap.this.bootstrapOnlyLocalEntries && re.originIdentifier() != ReplicatedChronicleMap.this.localIdentifier)) {
                this.raiseChange(n, compiledReplicatedMapIterationContext.pos());
            }
        }
    }
}

