/*
 * Copyright 2016 higherfrequencytrading.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.openhft.chronicle.network.cluster;

/**
 * @author Rob Austin.
 */

import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

/**
 * Handles the connection strategy ( in other words when to accept or reject a connection ) and
 * heart beating )
 *
 * @author Rob Austin.
 */
public class HostIdConnectionStrategy implements ConnectionStrategy, Demarshallable, WriteMarshallable {

    @UsedViaReflection
    private HostIdConnectionStrategy(WireIn w) {
    }

    public HostIdConnectionStrategy() {
    }

    /**
     * @return false if already connected
     */
    @Override
    public synchronized boolean notifyConnected(@NotNull WireTcpHandler handler,
                                                int localIdentifier,
                                                int remoteIdentifier) {

        if (!handler.nc().isAcceptor())
            return true;

        return localIdentifier > remoteIdentifier;
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wire) {

    }
}

