/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import net.openhft.chronicle.network.AlwaysStartOnPrimaryConnectionStrategy;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.connection.FatalFailureMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.wire.JSONWire;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlwaysStartOnPrimaryConnectionStrategyTest
extends NetworkTestCommon {
    private static String uri;

    @Override
    public void tearDown() {
        TCPRegistry.reset();
    }

    @Before
    public void setUp() throws IOException {
        String hostPort = "host.port";
        TCPRegistry.createServerSocketChannelFor((String)hostPort);
        uri = TCPRegistry.acquireServerSocketChannel((String)hostPort).getLocalAddress().toString();
    }

    @Test(timeout=1000L)
    public void connect_attempts_should_stop_when_thread_is_interrupted() throws InterruptedException {
        Thread thread = new Thread(() -> {
            AlwaysStartOnPrimaryConnectionStrategy strategy = new AlwaysStartOnPrimaryConnectionStrategy();
            try {
                strategy.connect("unavailable_uri", SocketAddressSupplier.uri((String)uri), false, new FatalFailureMonitor(){});
            }
            catch (InterruptedException e) {
                Assert.fail((String)("AlwaysStartOnPrimaryConnectionStrategy#connect should not have propagated the " + e.getClass()));
            }
        });
        thread.start();
        thread.interrupt();
        thread.join();
    }

    @Test
    public void test() {
        TCPRegistry.reset();
        AlwaysStartOnPrimaryConnectionStrategy alwaysStartOnPrimaryConnectionStrategy = new AlwaysStartOnPrimaryConnectionStrategy();
        JSONWire jsonWire = new JSONWire().useTypes(true);
        jsonWire.getValueOut().object((Object)alwaysStartOnPrimaryConnectionStrategy);
        Assert.assertEquals((Object)"{\"@AlwaysStartOnPrimaryConnectionStrategy\":{}}", (Object)jsonWire.bytes().toString());
    }
}

