/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.cluster.Cluster;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ClusterTest
extends NetworkTestCommon {
    @Test
    public <T extends ClusteredNetworkContext<T>> void testDeepCopy() {
        MyClusterContext cc = (MyClusterContext)new MyClusterContext().value(22).wireType(WireType.TEXT);
        String s = Marshallable.$toString((WriteMarshallable)cc);
        MyClusterContext o = (MyClusterContext)((Object)Marshallable.fromString((CharSequence)s));
        Assert.assertEquals((long)cc.value, (long)o.value);
        MyClusterContext cc2 = (MyClusterContext)((Object)cc.deepCopy());
        Assert.assertEquals((long)cc.value, (long)cc2.value);
        try (MyCluster c = new MyCluster();){
            c.clusterContext(cc);
            try (Cluster c2 = (Cluster)c.deepCopy();){
                MyClusterContext mcc = (MyClusterContext)c2.clusterContext();
                Assert.assertNotNull((Object)((Object)mcc));
                Assert.assertEquals((long)22L, (long)mcc.value);
            }
        }
    }

    static class MyClusterContext<T extends ClusteredNetworkContext<T>>
    extends ClusterContext<MyClusterContext<T>, T> {
        int value;

        MyClusterContext() {
        }

        protected String clusterNamePrefix() {
            return "";
        }

        @NotNull
        public ThrowingFunction<T, TcpEventHandler<T>, IOException> tcpEventHandlerFactory() {
            return null;
        }

        public MyClusterContext<T> value(int v) {
            this.value = v;
            return this;
        }

        protected void defaults() {
        }
    }

    private static class MyCluster<T extends ClusteredNetworkContext<T>>
    extends Cluster<T, MyClusterContext<T>> {
    }
}

