/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.network.TCPRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class NetworkTestCommon {
    protected ThreadDump threadDump;
    protected Map<ExceptionKey, Integer> exceptions;
    private final Map<Predicate<ExceptionKey>, String> expectedExceptions = new LinkedHashMap<Predicate<ExceptionKey>, String>();

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    public void assertReferencesReleased() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void recordExceptions() {
        this.exceptions = Jvm.recordExceptions();
        this.expectException("unable to connect to any of the hosts");
    }

    public void expectException(String message) {
        this.expectException(k -> k.message.contains(message) || k.throwable != null && k.throwable.getMessage() != null && k.throwable.getMessage().contains(message), message);
    }

    public void expectException(Predicate<ExceptionKey> predicate, String description) {
        this.expectedExceptions.put(predicate, description);
    }

    public void checkExceptions() {
        for (Map.Entry<Predicate<ExceptionKey>, String> expectedException : this.expectedExceptions.entrySet()) {
            if (this.exceptions.keySet().removeIf(expectedException.getKey()) || expectedException.getValue().equals("unable to connect to any of the hosts")) continue;
            Slf4jExceptionHandler.WARN.on(this.getClass(), "No error for " + expectedException.getValue());
        }
        this.expectedExceptions.clear();
        if (Jvm.hasException(this.exceptions)) {
            Jvm.dumpException(this.exceptions);
            Jvm.resetExceptionHandlers();
            Assert.fail();
        }
    }

    @After
    public void afterChecks() {
        this.preAfter();
        SystemTimeProvider.CLOCK = SystemTimeProvider.INSTANCE;
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        System.gc();
        AbstractCloseable.waitForCloseablesToClose((long)100L);
        TCPRegistry.reset();
        this.assertReferencesReleased();
        this.checkThreadDump();
        this.checkExceptions();
        this.tearDown();
    }

    protected void preAfter() {
    }

    protected void tearDown() {
    }
}

