/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.TCPRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TCPRegistryTest
extends NetworkTestCommon {
    private final boolean useCrossProcess;

    public TCPRegistryTest(boolean useCrossProcess) {
        this.useCrossProcess = useCrossProcess;
    }

    @Parameterized.Parameters(name="useCrossProcess = {0}")
    public static Collection<Object> params() {
        return Arrays.asList(false, true);
    }

    @Before
    public void setUp() {
        if (this.useCrossProcess) {
            TCPRegistry.useCrossProcessRegistry();
        }
    }

    @Override
    @After
    public void tearDown() {
        TCPRegistry.useInMemoryRegistry();
    }

    @Test
    public void testResetClearsRegistry() throws IOException {
        TCPRegistry.createServerSocketChannelFor((String[])new String[]{"host1", "host2", "host3"});
        Assert.assertNotNull((Object)TCPRegistry.lookup((String)"host1"));
        Assert.assertNotNull((Object)TCPRegistry.lookup((String)"host2"));
        Assert.assertNotNull((Object)TCPRegistry.lookup((String)"host3"));
        TCPRegistry.reset();
        this.assertNotMapped("host1");
        this.assertNotMapped("host2");
        this.assertNotMapped("host3");
    }

    @Test
    public void testResetIsIdempotent() throws IOException {
        TCPRegistry.createServerSocketChannelFor((String[])new String[]{"host1", "host2", "host3"});
        TCPRegistry.reset();
        TCPRegistry.reset();
    }

    private void assertNotMapped(String hostName) {
        try {
            TCPRegistry.lookup((String)hostName);
            Assert.fail((String)String.format("Found mapping for %s", hostName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

