/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.api.TcpHandler;
import org.jetbrains.annotations.NotNull;
import org.junit.Before;
import org.junit.Test;

public class TcpEventHandlerReleaseTest
extends NetworkTestCommon {
    private static final String hostPort = "host.port";

    @Before
    public void setUp() throws IOException {
        TCPRegistry.createServerSocketChannelFor((String)hostPort);
    }

    @Override
    protected void preAfter() {
        super.preAfter();
        TCPRegistry.reset();
    }

    @Test
    public void testRelease() throws IOException {
        try (TcpEventHandler t = this.createTcpEventHandler();){
            t.loopFinished();
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBuffersReleasedWhenSocketChannelClosed() throws IOException {
        block15: {
            try (TcpEventHandler t = this.createTcpEventHandler();){
                t.socketChannel().close();
                try {
                    t.action();
                    TestCase.fail();
                }
                catch (InvalidEventHandlerException invalidEventHandlerException) {
                    t.loopFinished();
                    break block15;
                }
                catch (Throwable throwable) {
                    t.loopFinished();
                    throw throwable;
                }
                t.loopFinished();
            }
        }
    }

    @Test
    public void performIdleWorkIsOnlyCalledWhenHandlerIsBusyOrOneHundredIterations() throws IOException, InvalidEventHandlerException {
        VanillaNetworkContext nc = new VanillaNetworkContext();
        nc.socketChannel(TCPRegistry.createSocketChannel((String)hostPort));
        BusyTcpEventHandler<VanillaNetworkContext> tcpEventHandler = new BusyTcpEventHandler<VanillaNetworkContext>(nc);
        BusyTcpHandler tcpHandler = new BusyTcpHandler();
        tcpEventHandler.tcpHandler(tcpHandler);
        ((BusyTcpEventHandler)tcpEventHandler).busy = true;
        tcpEventHandler.action();
        TestCase.assertEquals((int)0, (int)tcpHandler.performedIdleWorkCount.get());
        ((BusyTcpEventHandler)tcpEventHandler).busy = false;
        tcpEventHandler.action();
        TestCase.assertEquals((int)1, (int)tcpHandler.performedIdleWorkCount.get());
        ((BusyTcpEventHandler)tcpEventHandler).busy = true;
        for (int i = 0; i < 101; ++i) {
            tcpEventHandler.action();
        }
        TestCase.assertEquals((int)1, (int)tcpHandler.performedIdleWorkCount.get());
        tcpEventHandler.action();
        TestCase.assertEquals((int)2, (int)tcpHandler.performedIdleWorkCount.get());
        tcpEventHandler.close();
    }

    public TcpEventHandler createTcpEventHandler() throws IOException {
        VanillaNetworkContext nc = new VanillaNetworkContext();
        nc.socketChannel(TCPRegistry.createSocketChannel((String)hostPort));
        TcpEventHandler tcpEventHandler = new TcpEventHandler((NetworkContext)nc);
        tcpEventHandler.tcpHandler((TcpHandler)NullTcpHandler.INSTANCE);
        return tcpEventHandler;
    }

    private static class BusyTcpHandler<N extends NetworkContext<N>>
    implements TcpHandler<N> {
        private final AtomicInteger performedIdleWorkCount = new AtomicInteger();

        private BusyTcpHandler() {
        }

        public void process(@NotNull Bytes<?> in, @NotNull Bytes<?> out, N nc) {
        }

        public void close() {
        }

        public boolean isClosed() {
            return false;
        }

        public void performIdleWork() {
            this.performedIdleWorkCount.incrementAndGet();
        }
    }

    private static class BusyTcpEventHandler<N extends NetworkContext<N>>
    extends TcpEventHandler<N> {
        private boolean busy = true;

        public BusyTcpEventHandler(@NotNull N nc) {
            super(nc, true);
        }

        public boolean writeAction() {
            return this.busy;
        }
    }

    static enum NullTcpHandler implements TcpHandler
    {
        INSTANCE;


        public void process(@NotNull Bytes in, @NotNull Bytes out, NetworkContext nc) {
        }

        public void close() {
        }

        public boolean isClosed() {
            return false;
        }
    }
}

