/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.network.NetworkStatsAdapter;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import org.junit.Assert;
import org.junit.Test;

public class VanillaNetworkContextTest
extends NetworkTestCommon {
    @Test
    public void networkStatsListenerShouldNotBeClosedOnBackgroundResourceReleaserThread() throws TimeoutException {
        VanillaNetworkContext vanillaNetworkContext = new VanillaNetworkContext();
        final AtomicReference wasClosedInBackgroundReleaserThread = new AtomicReference();
        vanillaNetworkContext.networkStatsListener((NetworkStatsListener)new NetworkStatsAdapter(){

            @Override
            public void close() {
                wasClosedInBackgroundReleaserThread.set(BackgroundResourceReleaser.isOnBackgroundResourceReleaserThread());
            }
        });
        vanillaNetworkContext.close();
        TimingPauser pauser = Pauser.balanced();
        while (wasClosedInBackgroundReleaserThread.get() == null) {
            pauser.pause(5L, TimeUnit.SECONDS);
        }
        Assert.assertFalse((boolean)((Boolean)wasClosedInBackgroundReleaserThread.get()));
    }
}

