/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.cluster.ClusterAcceptorEventHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.HostConnector;
import net.openhft.chronicle.network.cluster.VanillaClusteredNetworkContext;
import net.openhft.chronicle.network.connection.VanillaWireOutPublisher;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.EventGroupBuilder;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ClusterAcceptorEventHandlerTest {
    @Test
    public void willPopulateNetworkStatsListenerWhenNetworkStatsListenerFactorySpecified() throws IOException {
        TCPRegistry.createServerSocketChannelFor((String)"testAcceptor");
        MyClusterContext acceptorContext = new MyClusterContext();
        NetworkStatsListener nsl = (NetworkStatsListener)Mockito.mock(NetworkStatsListener.class);
        acceptorContext.networkStatsListenerFactory(clusterContext -> nsl);
        ClusterAcceptorEventHandler acceptorEventHandler = new ClusterAcceptorEventHandler("testAcceptor", (ClusterContext)acceptorContext);
        EventGroup eventLoop = EventGroupBuilder.builder().build();
        eventLoop.addHandler((EventHandler)acceptorEventHandler);
        eventLoop.start();
        MyClusterContext initiaitorContext = new MyClusterContext();
        HostConnector connector = new HostConnector((ClusterContext)initiaitorContext, new RemoteConnector(initiaitorContext.tcpEventHandlerFactory()), 1, "testAcceptor");
        connector.connect();
        initiaitorContext.eventLoop().start();
        while (acceptorContext.tcpEventHandlers.size() == 0) {
            Jvm.pause((long)10L);
        }
        Assert.assertSame((Object)nsl, (Object)((NetworkContextExposingTcpEventHandler)((Object)acceptorContext.tcpEventHandlers.get(0))).nc.networkStatsListener());
        ((NetworkStatsListener)Mockito.verify((Object)nsl)).networkContext((NetworkContext)ArgumentMatchers.any(MyClusteredNetworkContext.class));
    }

    static class MyClusteredNetworkContext
    extends VanillaClusteredNetworkContext<MyClusteredNetworkContext, MyClusterContext> {
        public MyClusteredNetworkContext(@NotNull MyClusterContext clusterContext) {
            super((ClusterContext)clusterContext);
        }
    }

    static class NetworkContextExposingTcpEventHandler
    extends TcpEventHandler<MyClusteredNetworkContext> {
        private final MyClusteredNetworkContext nc;

        public NetworkContextExposingTcpEventHandler(@NotNull MyClusteredNetworkContext nc) {
            super((NetworkContext)nc);
            this.nc = nc;
        }
    }

    static class MyClusterContext
    extends ClusterContext<MyClusterContext, MyClusteredNetworkContext> {
        private final List<NetworkContextExposingTcpEventHandler> tcpEventHandlers = new ArrayList<NetworkContextExposingTcpEventHandler>();

        MyClusterContext() {
        }

        @NotNull
        public ThrowingFunction<MyClusteredNetworkContext, TcpEventHandler<MyClusteredNetworkContext>, IOException> tcpEventHandlerFactory() {
            return this::createTcpEventHandler;
        }

        @NotNull
        private TcpEventHandler<MyClusteredNetworkContext> createTcpEventHandler(MyClusteredNetworkContext clusteredNetworkContext) {
            NetworkContextExposingTcpEventHandler tcpEventHandler = new NetworkContextExposingTcpEventHandler(clusteredNetworkContext);
            this.tcpEventHandlers.add(tcpEventHandler);
            return tcpEventHandler;
        }

        protected void defaults() {
            this.wireType(WireType.BINARY);
            this.wireOutPublisherFactory(VanillaWireOutPublisher::new);
            this.serverThreadingStrategy(ServerThreadingStrategy.SINGLE_THREADED);
            this.networkContextFactory(MyClusteredNetworkContext::new);
        }

        protected String clusterNamePrefix() {
            return "testAcceptor";
        }
    }
}

