/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.VanillaClusteredNetworkContext;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ClusterContextTest {
    @Test
    public void testStatesAreStillInTheCorrectOrder() {
        Assert.assertArrayEquals((Object[])ClusterContext.Status.values(), (Object[])new ClusterContext.Status[]{ClusterContext.Status.NOT_CLOSED, ClusterContext.Status.STOPPING, ClusterContext.Status.CLOSING, ClusterContext.Status.CLOSED});
    }

    @Test
    public void isClosingAndIsClosedReturnFalseWhenNotClosed() {
        TestClusterContext testClusterContext = new TestClusterContext();
        Assert.assertFalse((boolean)testClusterContext.isClosed());
        Assert.assertFalse((boolean)testClusterContext.isClosing());
    }

    @Test
    public void isClosingAndIsClosedReturnsFalseWhenWeAreInPerformStopMethod() throws InterruptedException {
        BlockingTestClusterContext tcc = new BlockingTestClusterContext();
        tcc.closeGate.release();
        Thread t = new Thread(() -> ((BlockingTestClusterContext)tcc).close());
        t.start();
        while (!tcc.stopGate.hasQueuedThreads()) {
            Jvm.pause((long)1L);
        }
        Assert.assertFalse((boolean)tcc.isClosing());
        Assert.assertFalse((boolean)tcc.isClosed());
        tcc.stopGate.release();
        t.join();
    }

    @Test
    public void isClosingReturnsTrueAndIsClosedReturnsFalseWhenWeAreInPerformCloseMethod() throws InterruptedException {
        BlockingTestClusterContext tcc = new BlockingTestClusterContext();
        tcc.stopGate.release();
        Thread t = new Thread(() -> ((BlockingTestClusterContext)tcc).close());
        t.start();
        while (!tcc.closeGate.hasQueuedThreads()) {
            Jvm.pause((long)1L);
        }
        Assert.assertTrue((boolean)tcc.isClosing());
        Assert.assertFalse((boolean)tcc.isClosed());
        tcc.closeGate.release();
        t.join();
    }

    @Test
    public void isClosingAndIsClosedReturnTrueWhenClosed() throws TimeoutException {
        TestClusterContext tcc = new TestClusterContext();
        tcc.close();
        TimingPauser pauser = Pauser.balanced();
        while (!tcc.isClosed() || !tcc.isClosing()) {
            pauser.pause(3L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void subsequentThreadsBlockUntilClosedWhenCloseIsCalledByMultiThreads() throws InterruptedException {
        BlockingTestClusterContext tcc = new BlockingTestClusterContext();
        tcc.stopGate.release();
        Thread firstCloser = new Thread(() -> ((BlockingTestClusterContext)tcc).close());
        firstCloser.start();
        while (!tcc.closeGate.hasQueuedThreads()) {
            Jvm.pause((long)1L);
        }
        AtomicBoolean closeReturnForSecondCloser = new AtomicBoolean(false);
        Thread secondCloser = new Thread(() -> {
            tcc.close();
            closeReturnForSecondCloser.set(true);
        });
        secondCloser.start();
        long endTime = System.currentTimeMillis() + 500L;
        while (System.currentTimeMillis() < endTime) {
            Assert.assertFalse((boolean)closeReturnForSecondCloser.get());
            Jvm.pause((long)1L);
        }
        tcc.closeGate.release();
        firstCloser.join();
        secondCloser.join();
    }

    class TestNetworkContext
    extends VanillaClusteredNetworkContext<TestNetworkContext, TestClusterContext> {
        public TestNetworkContext(TestClusterContext clusterContext) {
            super((ClusterContext)clusterContext);
        }
    }

    class TestClusterContext
    extends ClusterContext<TestClusterContext, TestNetworkContext> {
        TestClusterContext() {
        }

        @NotNull
        public ThrowingFunction<TestNetworkContext, TcpEventHandler<TestNetworkContext>, IOException> tcpEventHandlerFactory() {
            return TcpEventHandler::new;
        }

        protected void defaults() {
        }

        protected String clusterNamePrefix() {
            return "test";
        }
    }

    class BlockingTestClusterContext
    extends TestClusterContext {
        public Semaphore stopGate = new Semaphore(0);
        public Semaphore closeGate = new Semaphore(0);

        BlockingTestClusterContext() {
        }

        protected void performStop() {
            super.performStop();
            this.waitAtGate(this.stopGate);
        }

        protected void performClose() {
            super.performClose();
            this.waitAtGate(this.closeGate);
        }

        private void waitAtGate(Semaphore semaphore) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

