/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConnectionManagerTest
extends NetworkTestCommon {
    private ConnectionManager<TestNetworkContext> connectionManager;
    private TestNetworkContext networkContext;
    @Mock
    private ConnectionManager.ConnectionListener<TestNetworkContext> listener1;
    @Mock
    private ConnectionManager.ConnectionListener<TestNetworkContext> listener2;

    @Before
    public void setUp() {
        this.connectionManager = new ConnectionManager();
        this.networkContext = new TestNetworkContext();
    }

    @Override
    @After
    public void tearDown() {
        Closeable.closeQuietly((Object)((Object)this.networkContext));
    }

    @Test
    public void onConnectionChangedExecutesAllListeners() {
        this.connectionManager.addListener(this.listener1);
        this.connectionManager.addListener(this.listener2);
        this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, null);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener2)).onConnectionChange((NetworkContext)this.networkContext, true);
    }

    @Test
    public void onConnectionChangedOnlyExecutesListenersWhenConnectionStateChanges() {
        this.connectionManager.addListener(this.listener1);
        this.connectionManager.addListener(this.listener2);
        ConnectionManager.EventEmitterToken token = this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, null);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener2)).onConnectionChange((NetworkContext)this.networkContext, true);
        this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, token);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener2)).onConnectionChange((NetworkContext)this.networkContext, true);
        this.connectionManager.onConnectionChanged(false, (NetworkContext)this.networkContext, token);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, false);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener2)).onConnectionChange((NetworkContext)this.networkContext, false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener1, this.listener2});
    }

    @Test
    public void executeNewListenersWillOnlyExecuteNonExecutedListeners() {
        this.connectionManager.addListener(this.listener1);
        ConnectionManager.EventEmitterToken token = this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, null);
        this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, token);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
        this.connectionManager.addListener(this.listener2);
        this.connectionManager.executeNewListeners((NetworkContext)this.networkContext, token);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener2)).onConnectionChange((NetworkContext)this.networkContext, true);
        this.connectionManager.executeNewListeners((NetworkContext)this.networkContext, token);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener2)).onConnectionChange((NetworkContext)this.networkContext, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener1, this.listener2});
    }

    @Test
    public void executeNewListenersWillExecuteAllListenersOnFirstCall() {
        ConnectionManager.EventEmitterToken eventEmitterToken = this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, null);
        this.connectionManager.addListener(this.listener1);
        this.connectionManager.addListener(this.listener2);
        this.connectionManager.executeNewListeners((NetworkContext)this.networkContext, eventEmitterToken);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener2)).onConnectionChange((NetworkContext)this.networkContext, true);
    }

    @Test
    public void executeNewListenersWillNotExecuteListenersThatPreviouslyThrewIllegalStateException() {
        ((ConnectionManager.ConnectionListener)Mockito.doThrow(IllegalStateException.class).when(this.listener2)).onConnectionChange((NetworkContext)ArgumentMatchers.any(), Mockito.anyBoolean());
        ConnectionManager.EventEmitterToken eventEmitterToken = this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, null);
        this.connectionManager.addListener(this.listener1);
        this.connectionManager.addListener(this.listener2);
        this.connectionManager.executeNewListeners((NetworkContext)this.networkContext, eventEmitterToken);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener2)).onConnectionChange((NetworkContext)this.networkContext, true);
    }

    @Test
    public void onConnectionChangedWorksWhenThereAreNoListeners() {
        ConnectionManager.EventEmitterToken token = this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, null);
        this.connectionManager.addListener(this.listener1);
        this.connectionManager.onConnectionChanged(false, (NetworkContext)this.networkContext, token);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, false);
    }

    @Test
    public void executeNewListenersWorksWhenThereAreNoListeners() {
        ConnectionManager.EventEmitterToken token = this.connectionManager.onConnectionChanged(true, (NetworkContext)this.networkContext, null);
        this.connectionManager.executeNewListeners((NetworkContext)this.networkContext, token);
        this.connectionManager.addListener(this.listener1);
        this.connectionManager.executeNewListeners((NetworkContext)this.networkContext, token);
        ((ConnectionManager.ConnectionListener)Mockito.verify(this.listener1)).onConnectionChange((NetworkContext)this.networkContext, true);
    }

    static class TestNetworkContext
    extends VanillaNetworkContext<TestNetworkContext> {
        TestNetworkContext() {
        }
    }
}

