/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster.handlers;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.cluster.handlers.HeartbeatHandler;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.WireIn;
import org.junit.Test;

public class HeartbeatHandlerTest {
    public static final long CID = 1234L;
    public static final int VALID_HEARTBEAT_TIMEOUT_MS = 1000;
    public static final int VALID_HEARTBEAT_INTERVAL_MS = 500;
    public static final int TOO_SMALL_HEARTBEAT_TIMEOUT_MS = 999;
    public static final int TOO_SMALL_HEARTBEAT_INTERVAL_MS = 499;

    @Test(expected=IllegalArgumentException.class)
    public void tooSmallHeartbeatIntervalMsThrowsIllegalArgumentException() {
        HeartbeatHandler.heartbeatHandler((long)1000L, (long)499L, (long)1234L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void tooSmallHeartbeatIntervalMsThrowsIllegalArgumentExceptionConstructor() {
        this.createByDeserialization(1000L, 499L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void tooSmallHeartbeatTimeoutMsThrowsIllegalArgumentException() {
        HeartbeatHandler.heartbeatHandler((long)999L, (long)500L, (long)1234L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void tooSmallHeartbeatTimeoutMsThrowsIllegalArgumentExceptionConstructor() {
        this.createByDeserialization(999L, 500L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void intervalEqualToTimeoutThrowsIllegalStateException() {
        HeartbeatHandler.heartbeatHandler((long)1000L, (long)1000L, (long)1234L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void intervalEqualToTimeoutThrowsIllegalStateExceptionConstructor() {
        this.createByDeserialization(1000L, 1000L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void intervalGreaterThanTimeoutThrowsIllegalStateException() {
        HeartbeatHandler.heartbeatHandler((long)1000L, (long)1100L, (long)1234L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void intervalGreaterThanTimeoutThrowsIllegalStateExceptionConstructor() {
        this.createByDeserialization(1000L, 1100L);
    }

    private void createByDeserialization(long heartbeatTimeoutMs, long heartbeatIntervalMs) {
        BinaryWire wire = new BinaryWire(Bytes.elasticByteBuffer());
        wire.write((CharSequence)"heartbeatTimeoutMs").int64(heartbeatTimeoutMs);
        wire.write((CharSequence)"heartbeatIntervalMs").int64(heartbeatIntervalMs);
        new HeartbeatHandler((WireIn)wire);
    }
}

