/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.internal;

import java.net.InetSocketAddress;
import java.security.Security;
import net.openhft.chronicle.network.internal.AddressCache;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;

public class AddressCacheTest {
    private static final String NETWORK_ADDRESS_CACHE_TTL = "networkaddress.cache.ttl";
    private static final String DEFAULT_NETWORK_ADDRESS_CACHE_TTL = "-1";
    private AddressCache addressCache;

    @Before
    public void setUp() {
        this.addressCache = new AddressCache();
    }

    @Test
    public void addingEntryWillMakeItAvailableForLookup() {
        this.addressCache.add("test-123", "google.com", 123);
        Assert.assertEquals((Object)this.addressCache.lookup("test-123"), (Object)new InetSocketAddress("google.com", 123));
    }

    @Test
    public void entriesAreUnavailableUntilAdded() {
        Assert.assertNull((Object)this.addressCache.lookup("test-123"));
    }

    @Test
    public void clearingWillMakeItUnavailableForLookup() {
        this.addressCache.add("test-123", "google.com", 123);
        Assert.assertEquals((Object)this.addressCache.lookup("test-123"), (Object)new InetSocketAddress("google.com", 123));
        this.addressCache.clear();
        Assert.assertNull((Object)this.addressCache.lookup("test-123"));
    }

    @Test
    public void resolvedAddressesAreCachedWhenCachingIsEnabled() throws Throwable {
        this.withNetworkAddressCacheTtl("100", () -> {
            this.addressCache.add("test-123", "google.com", 123);
            InetSocketAddress original = this.addressCache.lookup("test-123");
            Assert.assertSame((Object)original, (Object)this.addressCache.lookup("test-123"));
        });
    }

    @Test
    public void resolvedAddressesAreCachedWhenCachingForeverIsEnabled() throws Throwable {
        this.withNetworkAddressCacheTtl(DEFAULT_NETWORK_ADDRESS_CACHE_TTL, () -> {
            this.addressCache.add("test-123", "google.com", 123);
            InetSocketAddress original = this.addressCache.lookup("test-123");
            Assert.assertSame((Object)original, (Object)this.addressCache.lookup("test-123"));
        });
    }

    @Test
    public void resolvedAddressesAreNotCachedWhenCachingIsDisabled() throws Throwable {
        this.withNetworkAddressCacheTtl("0", () -> {
            this.addressCache.add("test-123", "google.com", 123);
            InetSocketAddress original = this.addressCache.lookup("test-123");
            Assert.assertNotSame((Object)original, (Object)this.addressCache.lookup("test-123"));
        });
    }

    private void withNetworkAddressCacheTtl(String ttlValue, ThrowingRunnable testCode) throws Throwable {
        Security.setProperty(NETWORK_ADDRESS_CACHE_TTL, ttlValue);
        try {
            testCode.run();
        }
        finally {
            Security.setProperty(NETWORK_ADDRESS_CACHE_TTL, DEFAULT_NETWORK_ADDRESS_CACHE_TTL);
        }
    }
}

