/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.internal.SocketExceptionUtil;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;
import net.openhft.chronicle.threads.Threads;
import org.junit.Assert;
import org.junit.Test;

public class SocketExceptionUtilTest
extends NetworkTestCommon {
    @Test
    public void isAConnectionResetExceptionReturnsTrueWhenMessageMatches() {
        Assert.assertTrue((boolean)SocketExceptionUtil.isAConnectionResetException((IOException)new IOException("Connection reset by peer")));
    }

    @Test
    public void isAConnectionResetExceptionReturnsTrueForSocketExceptionWithShorterMessage() {
        Assert.assertTrue((boolean)SocketExceptionUtil.isAConnectionResetException((IOException)new SocketException("Connection reset")));
    }

    @Test
    public void isAConnectionResetExceptionReturnsFalseForOtherExceptions() {
        Assert.assertFalse((boolean)SocketExceptionUtil.isAConnectionResetException((IOException)new SocketException("Something else happened")));
        Assert.assertFalse((boolean)SocketExceptionUtil.isAConnectionResetException((IOException)new IOException("Something else happened")));
    }

    @Test
    public void isAConnectionResetIsRobustAgainstNullMessages() {
        Assert.assertFalse((boolean)SocketExceptionUtil.isAConnectionResetException((IOException)new IOException()));
    }

    @Test
    public void testConnectionResetDetectionForLocales() throws IOException {
        Locale originalDefault = Locale.getDefault();
        try {
            Locale.setDefault(Locale.KOREA);
            this.testConnectionResetDetection();
            Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
            this.testConnectionResetDetection();
            Locale.setDefault(originalDefault);
            this.testConnectionResetDetection();
        }
        finally {
            Locale.setDefault(originalDefault);
        }
    }

    private void testConnectionResetDetection() throws IOException {
        ChronicleServerSocketChannel serverSocketChannel = TCPRegistry.createServerSocketChannelFor((String)"server-address");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.submit(() -> {
            try (ChronicleSocketChannel csc = serverSocketChannel.accept();){
                Jvm.pause((long)100L);
                Socket socket = csc.socketChannel().socket();
                socket.setSoLinger(true, 0);
                socket.close();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        try (ChronicleSocketChannel clientSocketChannel = ChronicleSocketChannelFactory.wrap((boolean)false, (InetSocketAddress)TCPRegistry.lookup((String)"server-address"));){
            clientSocketChannel.read(ByteBuffer.allocate(1000));
            Assert.fail((String)"Read should throw Connection reset exception");
        }
        catch (IOException e) {
            boolean identifiedCorrectly = SocketExceptionUtil.isAConnectionResetException((IOException)e);
            if (!identifiedCorrectly) {
                Jvm.error().on(SocketExceptionUtilTest.class, "Didn't identify connection reset exception correctly", (Throwable)e);
            }
            Assert.assertTrue((boolean)identifiedCorrectly);
        }
        Threads.shutdown((ExecutorService)executorService);
    }
}

