/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.internal.lookuptable;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.IntStream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.internal.lookuptable.FileBasedHostnamePortLookupTable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileBasedHostnamePortLookupTableTest
extends NetworkTestCommon {
    public static final String TEST_TABLE_FILENAME = "FileBasedHostnamePortLookupTableTest";
    private FileBasedHostnamePortLookupTable lookupTable;

    @Before
    public void setUp() {
        if (OS.isWindows()) {
            this.expectException("Error deleting the shared lookup table");
        }
        IOTools.deleteDirWithFilesOrThrow((String[])new String[]{TEST_TABLE_FILENAME});
        this.lookupTable = new FileBasedHostnamePortLookupTable(TEST_TABLE_FILENAME);
    }

    @Override
    @After
    public void tearDown() {
        Closeable.closeQuietly((Object)this.lookupTable);
    }

    @Test
    public void shouldStoreAndRetrieve() {
        InetSocketAddress localhost = new InetSocketAddress("localhost", 1234);
        this.lookupTable.put("aaa", localhost);
        Assert.assertEquals((Object)localhost, (Object)this.lookupTable.lookup("aaa"));
        this.lookupTable.put("bbb", localhost);
        Assert.assertEquals((Object)localhost, (Object)this.lookupTable.lookup("bbb"));
    }

    @Test
    public void shouldClear() {
        InetSocketAddress localhost = new InetSocketAddress("localhost", 1234);
        this.lookupTable.put("aaa", localhost);
        Assert.assertEquals((Object)localhost, (Object)this.lookupTable.lookup("aaa"));
        this.lookupTable.clear();
        Assert.assertNull((Object)this.lookupTable.lookup("aaa"));
    }

    @Test
    public void shouldGetAliases() {
        InetSocketAddress localhost = new InetSocketAddress("localhost", 1234);
        this.lookupTable.put("aaa", localhost);
        this.lookupTable.put("bbb", localhost);
        this.lookupTable.put("ccc", localhost);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("aaa", "bbb", "ccc")), (Object)this.lookupTable.aliases());
    }

    @Test
    public void shouldImplementForEach() {
        InetSocketAddress localhost = new InetSocketAddress("localhost", 1234);
        this.lookupTable.put("aaa", localhost);
        this.lookupTable.put("bbb", localhost);
        this.lookupTable.put("ccc", localhost);
        HashSet allValues = new HashSet();
        this.lookupTable.forEach((name, addr) -> {
            Assert.assertEquals((Object)localhost, (Object)addr);
            allValues.add(name);
        });
        Assert.assertEquals(new HashSet<String>(Arrays.asList("aaa", "bbb", "ccc")), allValues);
    }

    @Test
    public void entriesShouldBeVisibleAcrossInstances() throws IOException {
        try (FileBasedHostnamePortLookupTable table1 = new FileBasedHostnamePortLookupTable(TEST_TABLE_FILENAME);
             FileBasedHostnamePortLookupTable table2 = new FileBasedHostnamePortLookupTable(TEST_TABLE_FILENAME);){
            table1.put("aaa", InetSocketAddress.createUnresolved("aaa", 111));
            Assert.assertEquals((Object)table2.aliases(), Collections.singleton("aaa"));
            table2.put("bbb", InetSocketAddress.createUnresolved("bbb", 222));
            Assert.assertEquals((Object)table1.aliases(), new HashSet<String>(Arrays.asList("aaa", "bbb")));
        }
    }

    @Test(timeout=20000L)
    public void doShouldWorkConcurrently() {
        int seq = this.doShouldWorkConcurrently(false);
        int para = this.doShouldWorkConcurrently(true);
        Assert.assertTrue((seq > 0 ? 1 : 0) != 0);
        Assert.assertTrue((para > 0 ? 1 : 0) != 0);
        Jvm.startup().on(FileBasedHostnamePortLookupTable.class, "Sequential added: " + seq + ", parallel added: " + para);
    }

    public int doShouldWorkConcurrently(boolean parallel) {
        long start = System.currentTimeMillis();
        IntStream stream = IntStream.range(0, Math.min(16, Runtime.getRuntime().availableProcessors()));
        if (parallel) {
            stream = stream.parallel();
        }
        return stream.map(myId -> {
            try (FileBasedHostnamePortLookupTable table = new FileBasedHostnamePortLookupTable(TEST_TABLE_FILENAME);){
                HashSet<String> allMyAliases = new HashSet<String>();
                for (int i = 0; i < 200 && start + 2000L > System.currentTimeMillis(); ++i) {
                    String description = String.format("0." + (parallel ? "1" : "0") + ".%d.%d", myId, i);
                    allMyAliases.add(description);
                    InetSocketAddress address = InetSocketAddress.createUnresolved(description, i);
                    table.put(description, address);
                    InetSocketAddress lookup = table.lookup(description);
                    Assert.assertNotNull((String)description, (Object)lookup);
                }
                LinkedHashSet missing = new LinkedHashSet(allMyAliases);
                missing.removeAll(table.aliases());
                if (!missing.isEmpty()) {
                    Assert.fail((String)("Missing hosts " + missing));
                }
                int n = allMyAliases.size();
                return n;
            }
            catch (IOException e) {
                throw new AssertionError("Error creating lookup table", e);
            }
        }).sum();
    }

    @Test
    public void mappingsAreEqualRegardlessOfResolution() {
        FileBasedHostnamePortLookupTable.ProcessScopedMapping unresolved = new FileBasedHostnamePortLookupTable.ProcessScopedMapping(123, InetSocketAddress.createUnresolved("localhost", 456));
        FileBasedHostnamePortLookupTable.ProcessScopedMapping resolved = new FileBasedHostnamePortLookupTable.ProcessScopedMapping(123, new InetSocketAddress("localhost", 456));
        Assert.assertEquals((Object)unresolved, (Object)resolved);
    }

    @Test
    public void mappingsHaveSameHashCodeRegardlessOfResolution() {
        FileBasedHostnamePortLookupTable.ProcessScopedMapping unresolved = new FileBasedHostnamePortLookupTable.ProcessScopedMapping(123, InetSocketAddress.createUnresolved("localhost", 456));
        FileBasedHostnamePortLookupTable.ProcessScopedMapping resolved = new FileBasedHostnamePortLookupTable.ProcessScopedMapping(123, new InetSocketAddress("localhost", 456));
        Assert.assertEquals((long)unresolved.hashCode(), (long)resolved.hashCode());
    }

    @Test(expected=IllegalArgumentException.class)
    public void addressIsMandatory() {
        this.lookupTable.put("something", null);
    }
}

