/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.ssl.AbstractSocketBufferHandler;
import net.openhft.chronicle.network.ssl.SSLContextLoader;
import net.openhft.chronicle.network.ssl.StateMachineProcessor;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketFactory;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;
import net.openhft.chronicle.threads.NamedThreadFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class NioSslIntegrationTest
extends NetworkTestCommon {
    private static final boolean SEND_DATA_BEFORE_SSL_HANDSHAKE = Jvm.getBoolean((String)"ssl.test.payload");

    @Before
    public void setUp() {
        if (Jvm.majorVersion() >= 11) {
            System.setProperty("jdk.tls.server.protocols", "TLSv1.2");
        }
    }

    @After
    public void teardown() {
        System.clearProperty("jdk.tls.server.protocols");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldEncryptAndDecryptTraffic() throws Exception {
        ExecutorService threadPool = Executors.newFixedThreadPool(2, (ThreadFactory)new NamedThreadFactory("test"));
        ChronicleServerSocketChannel serverChannel = ChronicleServerSocketFactory.open((String)"localhost:13337");
        serverChannel.bind(new InetSocketAddress("0.0.0.0", 13337));
        serverChannel.setOption(StandardSocketOptions.SO_REUSEADDR, true);
        serverChannel.configureBlocking(true);
        ChronicleSocketChannel channel = ChronicleSocketChannelFactory.wrap();
        channel.configureBlocking(false);
        channel.connect(new InetSocketAddress("127.0.0.1", serverChannel.socket().getLocalPort()));
        try {
            Client client = new Client(channel);
            StateMachineProcessor clientProcessor = new StateMachineProcessor(channel, false, SSLContextLoader.getInitialisedContext(), client);
            ChronicleSocketChannel serverConnection = serverChannel.accept();
            serverConnection.configureBlocking(false);
            Server server = new Server(serverConnection);
            StateMachineProcessor serverProcessor = new StateMachineProcessor(serverConnection, true, SSLContextLoader.getInitialisedContext(), server);
            while (!channel.finishConnect() || !serverConnection.finishConnect()) {
                Thread.yield();
            }
            if (SEND_DATA_BEFORE_SSL_HANDSHAKE) {
                this.testDataConnection(channel, serverConnection);
            }
            threadPool.submit(clientProcessor);
            threadPool.submit(serverProcessor);
            client.waitForResponse(10L, TimeUnit.SECONDS);
            serverProcessor.stop();
            clientProcessor.stop();
            serverConnection.close();
        }
        catch (Throwable throwable) {
            Closeable.closeQuietly((Object[])new Object[]{channel, serverChannel});
            throw throwable;
        }
        Closeable.closeQuietly((Object[])new Object[]{channel, serverChannel});
        threadPool.shutdown();
        Assert.assertTrue((boolean)threadPool.awaitTermination(10L, TimeUnit.SECONDS));
    }

    private void testDataConnection(ChronicleSocketChannel channel, ChronicleSocketChannel serverConnection) throws IOException {
        ByteBuffer message = ByteBuffer.wrap("test message".getBytes(StandardCharsets.US_ASCII));
        while (message.hasRemaining()) {
            channel.write(message);
        }
        message.clear();
        while (message.hasRemaining()) {
            serverConnection.read(message);
        }
        message.flip();
        MatcherAssert.assertThat((Object)new String(message.array()), (Matcher)CoreMatchers.is((Object)"test message"));
    }

    private static final class Server
    extends AbstractSocketBufferHandler {
        private final ByteBuffer lastReceivedMessage = ByteBuffer.allocateDirect(64);

        Server(ChronicleSocketChannel channel) {
            super(channel);
        }

        public void handleDecryptedData(ByteBuffer input, ByteBuffer output) {
            if (input.hasRemaining() && input.remaining() != input.capacity()) {
                this.lastReceivedMessage.clear();
                this.lastReceivedMessage.put(input);
                this.lastReceivedMessage.flip();
            }
            if (this.lastReceivedMessage.remaining() != this.lastReceivedMessage.capacity() && this.lastReceivedMessage.hasRemaining()) {
                output.put("echo: ".getBytes(StandardCharsets.US_ASCII));
                output.put(this.lastReceivedMessage);
            }
        }
    }

    private static final class Client
    extends AbstractSocketBufferHandler {
        private final CountDownLatch latch = new CountDownLatch(1);
        private int counter = 0;
        private int responseCount = 0;

        Client(ChronicleSocketChannel socketChannel) {
            super(socketChannel);
        }

        void waitForResponse(long duration, TimeUnit timeUnit) throws InterruptedException {
            Assert.assertTrue((boolean)this.latch.await(duration, timeUnit));
        }

        public void handleDecryptedData(ByteBuffer input, ByteBuffer output) {
            if (input.hasRemaining() && input.remaining() != input.capacity()) {
                byte[] tmp = new byte[input.remaining()];
                input.get(tmp);
                String response = new String(tmp, StandardCharsets.UTF_8);
                if (this.responseCount++ == 5) {
                    this.latch.countDown();
                }
            }
            output.put(("hello " + this.counter++).getBytes(StandardCharsets.US_ASCII));
        }
    }
}

