/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.NetworkTestCommon;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.ssl.SSLContextLoader;
import net.openhft.chronicle.network.ssl.SslDelegatingTcpHandler;
import net.openhft.chronicle.network.ssl.SslNetworkContext;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.Pauser;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public final class NonClusteredSslIntegrationTest
extends NetworkTestCommon {
    private static final boolean DEBUG = Jvm.getBoolean((String)"NonClusteredSslIntegrationTest.debug");
    private final EventGroup client = EventGroup.builder().withPauser((Pauser)Pauser.millis((int)1)).withName("client").build();
    private final EventGroup server = EventGroup.builder().withPauser((Pauser)Pauser.millis((int)1)).withName("server").build();
    private final CountingTcpHandler clientAcceptor = new CountingTcpHandler("client-acceptor");
    private final CountingTcpHandler serverAcceptor = new CountingTcpHandler("server-acceptor");
    private final CountingTcpHandler clientInitiator = new CountingTcpHandler("client-initiator");
    private final CountingTcpHandler serverInitiator = new CountingTcpHandler("server-initiator");
    private final Mode mode;

    public NonClusteredSslIntegrationTest(String name, Mode mode) {
        this.mode = mode;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Arrays.stream(Mode.values()).forEach(m -> params.add(new Object[]{m.name(), m}));
        return params;
    }

    private static void waitForLatch(CountingTcpHandler handler) throws InterruptedException {
        Assert.assertTrue((String)("Handler for " + handler.label + " did not startup within timeout at " + Instant.now()), (boolean)handler.latch.await(25L, TimeUnit.SECONDS));
    }

    @Before
    public void setUp() throws Exception {
        TCPRegistry.reset();
        TCPRegistry.createServerSocketChannelFor((String[])new String[]{"client", "server"});
        this.client.addHandler((EventHandler)new AcceptorEventHandler("client", nc -> {
            TcpEventHandler eventHandler = new TcpEventHandler((NetworkContext)nc);
            eventHandler.tcpHandler(this.getTcpHandler(this.clientAcceptor));
            return eventHandler;
        }, () -> new StubNetworkContext()));
        this.server.addHandler((EventHandler)new AcceptorEventHandler("server", nc -> {
            TcpEventHandler eventHandler = new TcpEventHandler((NetworkContext)nc);
            eventHandler.tcpHandler(this.getTcpHandler(this.serverAcceptor));
            return eventHandler;
        }, () -> new StubNetworkContext()));
    }

    @Test(timeout=40000L)
    public void shouldCommunicate() throws Exception {
        Assume.assumeFalse((String)"BI_DIRECTIONAL mode sometimes hangs during handshake", (this.mode == Mode.BI_DIRECTIONAL ? 1 : 0) != 0);
        this.client.start();
        this.server.start();
        this.doConnect();
        switch (this.mode) {
            case CLIENT_TO_SERVER: {
                this.assertThatClientConnectsToServer();
                break;
            }
            case SERVER_TO_CLIENT: {
                this.assertThatServerConnectsToClient();
                break;
            }
            default: {
                this.assertThatClientConnectsToServer();
                this.assertThatServerConnectsToClient();
            }
        }
    }

    @Override
    public void tearDown() {
        this.client.close();
        this.client.stop();
        this.server.close();
        this.server.stop();
        TCPRegistry.reset();
        TCPRegistry.assertAllServersStopped();
    }

    private void doConnect() {
        if (this.mode == Mode.CLIENT_TO_SERVER || this.mode == Mode.BI_DIRECTIONAL) {
            new RemoteConnector(nc -> {
                TcpEventHandler eventHandler = new TcpEventHandler((NetworkContext)nc);
                eventHandler.tcpHandler(this.getTcpHandler(this.clientInitiator));
                return eventHandler;
            }).connect("server", (EventLoop)this.client, (NetworkContext)new StubNetworkContext(), 1000L);
        }
        if (this.mode == Mode.SERVER_TO_CLIENT || this.mode == Mode.BI_DIRECTIONAL) {
            new RemoteConnector(nc -> {
                TcpEventHandler eventHandler = new TcpEventHandler((NetworkContext)nc);
                eventHandler.tcpHandler(this.getTcpHandler(this.serverInitiator));
                return eventHandler;
            }).connect("client", (EventLoop)this.server, (NetworkContext)new StubNetworkContext(), 1000L);
        }
    }

    @NotNull
    private TcpHandler<StubNetworkContext> getTcpHandler(CountingTcpHandler delegate) {
        return new SslDelegatingTcpHandler((TcpHandler)delegate);
    }

    private void assertThatServerConnectsToClient() throws InterruptedException {
        NonClusteredSslIntegrationTest.waitForLatch(this.clientAcceptor);
        NonClusteredSslIntegrationTest.waitForLatch(this.serverInitiator);
        while (this.serverInitiator.operationCount < 10L || this.clientAcceptor.operationCount < 10L) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((this.serverInitiator.operationCount > 9L ? 1 : 0) != 0);
        Assert.assertTrue((this.clientAcceptor.operationCount > 9L ? 1 : 0) != 0);
    }

    private void assertThatClientConnectsToServer() throws InterruptedException {
        NonClusteredSslIntegrationTest.waitForLatch(this.serverAcceptor);
        NonClusteredSslIntegrationTest.waitForLatch(this.clientInitiator);
        while (this.clientInitiator.operationCount < 10L || this.serverAcceptor.operationCount < 10L) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((this.clientInitiator.operationCount > 9L ? 1 : 0) != 0);
        Assert.assertTrue((this.serverAcceptor.operationCount > 9L ? 1 : 0) != 0);
    }

    private static final class StubNetworkContext
    extends VanillaNetworkContext<StubNetworkContext>
    implements SslNetworkContext<StubNetworkContext> {
        private StubNetworkContext() {
        }

        public SSLContext sslContext() {
            try {
                return SSLContextLoader.getInitialisedContext();
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new RuntimeException("Failed to initialise ssl context", e);
            }
        }

        @NotNull
        public StubNetworkContext socketChannel(ChronicleSocketChannel socketChannel) {
            return (StubNetworkContext)super.socketChannel(socketChannel);
        }

        public ServerThreadingStrategy serverThreadingStrategy() {
            return ServerThreadingStrategy.CONCURRENT;
        }

        public NetworkStatsListener<StubNetworkContext> networkStatsListener() {
            return new NetworkStatsListener<StubNetworkContext>(){

                public void networkContext(StubNetworkContext networkContext) {
                }

                public void onNetworkStats(long writeBps, long readBps, long socketPollCountPerSecond) {
                }

                public void onHostPort(String hostName, int port) {
                }

                public void onRoundTripLatency(long nanosecondLatency) {
                }

                public void close() {
                }

                public boolean isClosed() {
                    return false;
                }
            };
        }
    }

    private static final class CountingTcpHandler
    extends SimpleCloseable
    implements TcpHandler<StubNetworkContext> {
        private final String label;
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile long operationCount = 0L;
        private long counter = 0L;
        private long lastSent = 0L;

        CountingTcpHandler(String label) {
            this.label = label;
        }

        public void process(@NotNull Bytes<?> in, @NotNull Bytes<?> out, StubNetworkContext nc) {
            this.latch.countDown();
            try {
                if (nc.isAcceptor() && in.readRemaining() != 0L) {
                    int magic = in.readInt();
                    if (magic != -19088744) {
                        throw new IllegalStateException("Invalid magic number " + Integer.toHexString(magic));
                    }
                    long received = in.readLong();
                    int len = in.readInt();
                    byte[] tmp = new byte[len];
                    in.read(tmp);
                    if (!DEBUG || len > 10) {
                        // empty if block
                    }
                    ++this.operationCount;
                } else if (!nc.isAcceptor() && System.currentTimeMillis() > this.lastSent + 100L) {
                    out.writeInt(-19088744);
                    out.writeLong(this.counter++);
                    String payload = "ping-" + (this.counter - 1L);
                    out.writeInt(payload.length());
                    out.write(payload.getBytes(StandardCharsets.US_ASCII));
                    if (DEBUG) {
                        // empty if block
                    }
                    ++this.operationCount;
                    this.lastSent = System.currentTimeMillis();
                }
            }
            catch (RuntimeException e) {
                System.err.printf("Exception in %s: %s/%s%n", this.label, e.getClass().getSimpleName(), e.getMessage());
                e.printStackTrace();
            }
        }

        protected void performClose() {
        }
    }

    private static enum Mode {
        CLIENT_TO_SERVER,
        SERVER_TO_CLIENT,
        BI_DIRECTIONAL;

    }
}

