/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.WireKey;

final class PingSender
implements EventHandler {
    private final Supplier<NetworkContext> nc;
    private final IntSupplier local;
    private final IntSupplier remote;
    private final long cid;
    private long lastPublish = 0L;
    private int counter;

    PingSender(Supplier<NetworkContext> nc, IntSupplier local, IntSupplier remote, long cid) {
        this.nc = nc;
        this.local = local;
        this.remote = remote;
        this.cid = cid;
    }

    public boolean action() throws InvalidEventHandlerException {
        if (this.lastPublish < System.currentTimeMillis() - 5000L) {
            this.nc.get().wireOutPublisher().put(null, wireOut -> {
                wireOut.writeDocument(true, d -> d.write((WireKey)CoreFields.cid).int64(this.cid));
                wireOut.writeDocument(false, d -> d.writeEventName((CharSequence)"ping").int32(this.counter++));
            });
            this.lastPublish = System.currentTimeMillis();
        }
        return false;
    }
}

