/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import javax.net.ssl.SSLContext;
import net.openhft.chronicle.network.ssl.BufferHandler;
import net.openhft.chronicle.network.ssl.SslEngineStateMachine;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.threads.Pauser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StateMachineProcessor
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachineProcessor.class);
    private final SSLContext context;
    private final SslEngineStateMachine stateMachine;
    private final Pauser pauser = Pauser.balanced();
    private final ChronicleSocketChannel channel;
    private volatile boolean running = true;

    StateMachineProcessor(ChronicleSocketChannel channel, boolean isAcceptor, SSLContext context, BufferHandler bufferHandler) {
        this.context = context;
        this.channel = channel;
        this.stateMachine = new SslEngineStateMachine(bufferHandler, isAcceptor);
    }

    @Override
    public void run() {
        block4: {
            try {
                this.stateMachine.initialise(this.context, this.channel);
                while (!Thread.currentThread().isInterrupted() && this.running) {
                    while (this.running && this.stateMachine.action()) {
                        this.pauser.reset();
                    }
                    this.pauser.pause();
                }
            }
            catch (Throwable e) {
                if (!this.running) break block4;
                LOGGER.error("Exception caught while processing SSL state machine. Exiting.", e);
            }
        }
    }

    public void stop() {
        this.running = false;
    }
}

