/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.performance.tests.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.VanillaNetworkContext;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.network.tcp.ChronicleSocket;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.performance.tests.network.EchoHandler;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class BinaryTestBufferSize {
    @NotNull
    private static final String desc = "host.port";
    private EventLoop eg;
    private ThreadDump threadDump;

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void setUp() throws IOException {
        TCPRegistry.createServerSocketChannelFor((String)desc);
        this.eg = EventGroup.builder().build();
        this.eg.start();
        this.createServer(desc, this.eg);
    }

    @After
    public void tearDown() {
        this.eg.stop();
        TcpChannelHub.closeAllHubs();
        TCPRegistry.reset();
    }

    @Ignore(value="TODO FIX")
    @Test
    public void test() throws IOException {
        this.sendAndReceive(65536);
    }

    private void sendAndReceive(int tcpBufferSize) throws IOException {
        for (int length = 1; length < 2000; ++length) {
            this.sendAndReceive(length, tcpBufferSize);
        }
    }

    private void sendAndReceive(int length, int tcpBufferSize) throws IOException {
        String expectedMessage = "";
        for (int i = 1; i <= length; ++i) {
            expectedMessage = expectedMessage + (char)(32 + i % 94);
        }
        this.sendAndReceive(expectedMessage, tcpBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndReceive(String expectedMessage, int tcpBufferSize) throws IOException {
        ChronicleSocketChannel client = this.createClient(desc, tcpBufferSize);
        assert (System.getProperty("TcpEventHandler.tcpBufferSize") == null);
        System.setProperty("TcpEventHandler.tcpBufferSize", Integer.toString(tcpBufferSize));
        Bytes inBytes = null;
        Bytes outBytes = null;
        try {
            int read;
            outBytes = (Bytes)Bytes.elasticByteBuffer().writeUtf8(expectedMessage);
            long totalBytes = outBytes.writePosition();
            ByteBuffer outBuff = (ByteBuffer)outBytes.underlyingObject();
            outBuff.clear();
            outBuff.limit((int)outBytes.writePosition());
            while (outBuff.hasRemaining()) {
                client.write(outBuff);
            }
            inBytes = Bytes.elasticByteBuffer((int)((int)totalBytes)).clear();
            ByteBuffer inBuff = (ByteBuffer)inBytes.underlyingObject();
            int totalRead = 0;
            int count = 0;
            while ((long)totalRead < totalBytes && (read = client.read(inBuff)) > -1) {
                assert (read != 0);
                totalRead += read;
                ++count;
            }
            if (count > 1) {
                inBytes.readLimit((long)totalRead);
            }
            Assert.assertEquals((Object)expectedMessage, (Object)inBytes.readUtf8());
        }
        finally {
            inBytes.releaseLast();
            outBytes.releaseLast();
            System.clearProperty("TcpEventHandler.tcpBufferSize");
            client.close();
        }
    }

    @NotNull
    private ChronicleSocketChannel createClient(@NotNull String desc, int tcpBufferSize) throws IOException {
        ChronicleSocketChannel result = TCPRegistry.createSocketChannel((String)desc);
        ChronicleSocket socket = result.socket();
        socket.setTcpNoDelay(true);
        socket.setReceiveBufferSize(tcpBufferSize);
        socket.setSendBufferSize(tcpBufferSize);
        result.configureBlocking(true);
        return result;
    }

    private <T extends VanillaNetworkContext<T>> void createServer(@NotNull String desc, @NotNull EventLoop eg) throws IOException {
        @NotNull AcceptorEventHandler eah = new AcceptorEventHandler(desc, networkContext -> {
            @NotNull TcpEventHandler handler = new TcpEventHandler((NetworkContext)networkContext);
            handler.tcpHandler(new EchoHandler());
            return handler;
        }, () -> new VanillaNetworkContext());
        eg.addHandler((EventHandler)eah);
        ChronicleSocketChannel sc = TCPRegistry.createSocketChannel((String)desc);
        sc.configureBlocking(false);
    }
}

